/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.common.util;

import com.els.tso.common.bo.PictureVerificationCodeBO;
import com.els.tso.common.exception.BusinessException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Random;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PictureUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PictureUtil.class);
    private static final int IMG_WIDTH = 85;
    private static final int IMG_HEIGHT = 35;
    private static final int CODE_COUNT = 4;
    private static final String FORMAT_NAME = "JPEG";
    private static final String FONT_STYLE = "Times New Roman";
    private static final int FONT_HEIGHT;
    private static final int CODEY;
    private static int x;

    public static PictureVerificationCodeBO generateVerificationCode() {
        PictureVerificationCodeBO pictureVerificationCodeBO;
        Base64.Encoder encoder;
        BufferedImage image = new BufferedImage(85, 35, 1);
        Graphics2D g = image.createGraphics();
        Random random = new Random();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 85, 35);
        g.setFont(new Font(FONT_STYLE, 2, FONT_HEIGHT));
        g.setColor(new Color(55, 55, 12));
        g.drawRect(0, 0, 84, 34);
        g.setColor(PictureUtil.getRandColor(160, 200));
        for (int i = 0; i < 10; ++i) {
            int x = random.nextInt(85);
            int y = random.nextInt(35);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }
        StringBuilder sRand = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int red = random.nextInt(255);
            int green = random.nextInt(255);
            int blue = random.nextInt(255);
            char retWord = PictureUtil.getSingleNumberChar();
            sRand.append(retWord);
            g.setColor(new Color(red, green, blue));
            g.drawString(String.valueOf(retWord), i * x, CODEY);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, FORMAT_NAME, bos);
            bos.flush();
            encoder = Base64.getEncoder();
            pictureVerificationCodeBO = new PictureVerificationCodeBO(sRand.toString(), encoder.encodeToString(bos.toByteArray()));
        }
        catch (IOException e) {
            throw new BusinessException("", e);
        }
        g.dispose();
        pictureVerificationCodeBO.setPicContentBase64(encoder.encodeToString(sRand.toString().getBytes(StandardCharsets.UTF_8)));
        return pictureVerificationCodeBO;
    }

    private static Color getRandColor(int fc, int bc) {
        Random random = new Random();
        int max = 255;
        if (fc > max) {
            fc = max;
        }
        if (bc > max) {
            bc = max;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static char getSingleNumberChar() {
        Random random = new Random();
        int numberResult = random.nextInt(10);
        int ret = numberResult + 48;
        return (char)ret;
    }

    static {
        x = 17;
        FONT_HEIGHT = 33;
        CODEY = 23;
    }
}

