/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.common.util;

import com.els.tso.common.bo.PictureCodeQuery;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class QrCodeUtil {
    public static void generateQr(PictureCodeQuery condition, OutputStream output) throws WriterException, IOException {
        BarcodeFormat format;
        QrCodeUtil.setDefaultValue(condition);
        int width = condition.getWidth();
        int height = condition.getHeight();
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        switch (condition.getBarcodeFormat()) {
            case 2: {
                format = BarcodeFormat.CODABAR;
                break;
            }
            case 3: {
                format = BarcodeFormat.CODE_128;
                break;
            }
            case 4: {
                format = BarcodeFormat.AZTEC;
                break;
            }
            default: {
                format = BarcodeFormat.QR_CODE;
            }
        }
        BitMatrix bm = new MultiFormatWriter().encode(condition.getContent(), format, width, height, hints);
        BufferedImage image = QrCodeUtil.toImage(bm, condition.getBgColor(), condition.getFgColor());
        ImageIO.write((RenderedImage)image, condition.getPicFormat(), output);
    }

    private static BufferedImage toImage(BitMatrix bm, int bgColor, int fgColor) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bm.get(x, y) ? fgColor : bgColor);
            }
        }
        return image;
    }

    private static void setDefaultValue(PictureCodeQuery condition) {
        if (StringUtils.isBlank((CharSequence)condition.getPicFormat())) {
            condition.setPicFormat("jpg");
        }
        if (StringUtils.isBlank((CharSequence)condition.getContent())) {
            condition.setContent("\u8bf7\u5199\u5165\u6570\u636e:");
        }
    }
}

