/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.common.util;

import java.net.InetAddress;

public class SnowflakeIdUtil {
    private static final long workerIdBits = 10L;
    private static final long datacenterIdBits = 5L;
    private static final long maxWorkerId = 1023L;
    private static final long maxDatacenterId = 31L;
    private static final SnowflakeIdUtil SNOWFLAKEIDUTILS = new SnowflakeIdUtil(SnowflakeIdUtil.getAddress() % 1024L, SnowflakeIdUtil.getAddress() % 31L + 1L);
    private final long twepoch = 1420041600000L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long datacenterIdShift = 22L;
    private final long timestampLeftShift = 27L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeIdUtil(long workerId, long datacenterId) {
        if (workerId > 1023L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 1023L));
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public static long getAddress() {
        try {
            String currentIpAddress = InetAddress.getLocalHost().getHostAddress();
            String[] str = currentIpAddress.split("\\.");
            StringBuilder hardware = new StringBuilder();
            for (int i = 0; i < str.length; ++i) {
                hardware.append(str[i]);
            }
            return Long.parseLong(hardware.toString());
        }
        catch (Exception exception) {
            return 2L;
        }
    }

    public static long getId() {
        return SNOWFLAKEIDUTILS.nextId();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100000; ++i) {
            System.out.println(SnowflakeIdUtil.getId());
        }
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1420041600000L << 27 | this.datacenterId << 22 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }
}

