package com.els.tso.contract.service.impl;

import com.els.tso.contract.service.TemplateEngineService;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

/**
 * @author daipj
 * @date 2020/9/10 10:52
 */
@Service
public class TemplateEngineServiceImpl implements TemplateEngineService {

    @Autowired
    private Configuration ftlConfiguration;

    @Override
    public String freeMarkerEvaluate(String toEvaluate, Map<String, Object> params) throws IOException, TemplateException {

        final String templateName = "toEvaluate";
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate(templateName, toEvaluate);
        ftlConfiguration.setTemplateLoader(stringTemplateLoader);
        Template template = ftlConfiguration.getTemplate(templateName);
        Writer out = new StringWriter();
        template.process(params, out);
        return out.toString();
    }

}
