/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.contract.controller;

import com.els.tso.contract.dao.FileUploadDao;
import com.els.tso.contract.entity.FileEntity;
import com.els.tso.contract.util.VelocityUtil;
import com.els.tso.contract.util.WordToHtml;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/fileUploadService"})
public class FileUploadController {
    @Resource
    private FileUploadDao fileUploadDao;

    @PostMapping(value={"/upload"})
    @ResponseBody
    public String upload(@RequestPart(value="multipartFile") MultipartFile multipartFile) throws IOException {
        String originalFilename = multipartFile.getOriginalFilename();
        String html = originalFilename.endsWith(".docx") ? WordToHtml.getInstance().word2007ToHtml(multipartFile.getInputStream()) : WordToHtml.getInstance().word2003ToHtml(multipartFile.getInputStream());
        if (StringUtils.isBlank((CharSequence)html)) {
            return null;
        }
        FileEntity fileEntity = new FileEntity();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        fileEntity.setFileName(originalFilename);
        fileEntity.setContent(html);
        fileEntity.setUuid(uuid);
        this.fileUploadDao.insert(fileEntity);
        return uuid;
    }

    @PostMapping(value={"/findFile"})
    @ResponseBody
    public String findFile(@RequestParam(value="uuid") String uuid, @RequestBody Map<String, Object> params) {
        FileEntity fileEntity = this.fileUploadDao.selectById(uuid);
        String str = fileEntity.getContent();
        return VelocityUtil.strEvaluate(str, params);
    }
}

