/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.contract.controller;

import fr.opensagres.poi.xwpf.converter.core.BasicURIResolver;
import fr.opensagres.poi.xwpf.converter.core.FileImageExtractor;
import fr.opensagres.poi.xwpf.converter.core.IImageExtractor;
import fr.opensagres.poi.xwpf.converter.core.IURIResolver;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLConverter;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.w3c.dom.Document;

@Controller
@RequestMapping(value={"/"})
public class ManualController {
    private static final Logger logger = LogManager.getLogger(ManualController.class);

    public static String Word2003ToHtml(String wordPath, String wordName, String suffix, String htmlPath) throws IOException, TransformerException, ParserConfigurationException {
        String htmlName = wordName + ".html";
        final String imagePath = htmlPath + "image" + File.separator;
        File htmlFile = new File(htmlPath + htmlName);
        if (htmlFile.exists()) {
            return htmlFile.getAbsolutePath();
        }
        String file = wordPath + File.separator + wordName + suffix;
        FileInputStream input = new FileInputStream(new File(file));
        HWPFDocument wordDocument = new HWPFDocument((InputStream)input);
        WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
        wordToHtmlConverter.setPicturesManager(new PicturesManager(){

            public String savePicture(byte[] content, PictureType pictureType, String suggestedName, float widthInches, float heightInches) {
                File imgPath = new File(imagePath);
                if (!imgPath.exists()) {
                    imgPath.mkdirs();
                }
                File file = new File(imagePath + suggestedName);
                try {
                    FileOutputStream os = new FileOutputStream(file);
                    ((OutputStream)os).write(content);
                    ((OutputStream)os).close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return "image/" + suggestedName;
            }
        });
        wordToHtmlConverter.processDocument((HWPFDocumentCore)wordDocument);
        Document htmlDocument = wordToHtmlConverter.getDocument();
        File folder = new File(htmlPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        FileOutputStream outStream = new FileOutputStream(htmlFile);
        DOMSource domSource = new DOMSource(htmlDocument);
        StreamResult streamResult = new StreamResult(outStream);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer serializer = factory.newTransformer();
        serializer.setOutputProperty("encoding", "utf-8");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("method", "html");
        serializer.transform(domSource, streamResult);
        return htmlFile.getAbsolutePath();
    }

    public static String Word2007ToHtml(String wordPath, String wordName, String suffix, String htmlPath) throws IOException {
        String htmlName = wordName + ".html";
        String imagePath = htmlPath + "image" + File.separator;
        File htmlFile = new File(htmlPath + htmlName);
        if (htmlFile.exists()) {
            return htmlFile.getAbsolutePath();
        }
        File wordFile = new File(wordPath + File.separator + wordName + suffix);
        FileInputStream in = new FileInputStream(wordFile);
        XWPFDocument document = new XWPFDocument((InputStream)in);
        File imgFolder = new File(imagePath);
        XHTMLOptions options = XHTMLOptions.create();
        options.setExtractor((IImageExtractor)new FileImageExtractor(imgFolder));
        options.URIResolver((IURIResolver)new BasicURIResolver("image"));
        options.setIgnoreStylesIfUnused(false);
        options.setFragment(true);
        File folder = new File(htmlPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(htmlFile);
        XHTMLConverter.getInstance().convert(document, (OutputStream)out, (Options)options);
        return htmlFile.getAbsolutePath();
    }

    public static void main(String[] args) {
        try {
            ManualController.Word2007ToHtml("E:\\Ning\\", "1", ".docx", "E://Ning/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

