/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.contract.util;

import fr.opensagres.poi.xwpf.converter.core.FileImageExtractor;
import fr.opensagres.poi.xwpf.converter.core.FileURIResolver;
import fr.opensagres.poi.xwpf.converter.core.IImageExtractor;
import fr.opensagres.poi.xwpf.converter.core.IURIResolver;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLConverter;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class WordToHtml {
    private static final Logger logger = LoggerFactory.getLogger(WordToHtml.class);
    private static WordToHtml instance = new WordToHtml();

    private WordToHtml() {
    }

    public static WordToHtml getInstance() {
        return instance;
    }

    public String word2007ToHtml(InputStream inStream) {
        XWPFDocument document = null;
        ByteArrayOutputStream outStream = null;
        try {
            document = new XWPFDocument(inStream);
            File imgPath = new File("");
            XHTMLOptions options = XHTMLOptions.create().URIResolver((IURIResolver)new FileURIResolver(imgPath)).setIgnoreStylesIfUnused(true);
            options.setExtractor((IImageExtractor)new FileImageExtractor(imgPath));
            outStream = new ByteArrayOutputStream();
            XHTMLConverter.getInstance().convert(document, (OutputStream)outStream, (Options)options);
            String content = new String(outStream.toByteArray(), StandardCharsets.UTF_8);
            String string = this.doFilter(content);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
                if (document != null) {
                    document.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String word2007ToHtml(File file) {
        try (FileInputStream inStream = new FileInputStream(file);){
            String string = this.word2007ToHtml(inStream);
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String word2003ToHtml(File file) {
        try (FileInputStream inStream = new FileInputStream(file);){
            String string = this.word2003ToHtml(inStream);
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String word2003ToHtml(InputStream istream) {
        HWPFDocument document = null;
        ByteArrayOutputStream outputStream = null;
        try {
            document = new HWPFDocument(istream);
            WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            wordToHtmlConverter.setPicturesManager(new PicturesManager(){

                public String savePicture(byte[] content, PictureType pictureType, String suggestedName, float widthInches, float heightInches) {
                    return suggestedName;
                }
            });
            wordToHtmlConverter.processDocument((HWPFDocumentCore)document);
            List pictures = document.getPicturesTable().getAllPictures();
            if (pictures.size() > 0) {
                String imgPath = "";
                File imgPathFile = new File(imgPath);
                if (!imgPathFile.exists()) {
                    imgPathFile.mkdirs();
                }
                for (Picture pic : pictures) {
                    pic.writeImageContent((OutputStream)new FileOutputStream(imgPath + File.separator + pic.suggestFullFileName()));
                }
            }
            Document htmlDocument = wordToHtmlConverter.getDocument();
            outputStream = new ByteArrayOutputStream();
            DOMSource domSource = new DOMSource(htmlDocument);
            StreamResult streamResult = new StreamResult(outputStream);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "utf-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
            serializer.transform(domSource, streamResult);
            String content = new String(outputStream.toByteArray());
            String string = this.doFilter(content);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (istream != null) {
                    istream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (document != null) {
                    document.close();
                }
            }
            catch (Exception e) {
                logger.error("IOException close error!", (Throwable)e);
            }
        }
    }

    public String doFilter(String content) {
        String regex = "\\$\\{.*?\\}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        while (m.find()) {
            String dist = this.delhtmltag(m.group());
            if ("${}".equalsIgnoreCase(dist)) {
                dist = "${r'${}'}";
            }
            content = content.replace(m.group(), dist);
        }
        return content;
    }

    public String delhtmltag(String htmlStr) {
        String regExScript = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regExStyle = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regExHtml = "<[^>]+>";
        Pattern pScript = Pattern.compile(regExScript, 2);
        Matcher mScript = pScript.matcher(htmlStr);
        htmlStr = mScript.replaceAll("");
        Pattern pStyle = Pattern.compile(regExStyle, 2);
        Matcher mStyle = pStyle.matcher(htmlStr);
        htmlStr = mStyle.replaceAll("");
        Pattern pHtml = Pattern.compile(regExHtml, 2);
        Matcher mHtml = pHtml.matcher(htmlStr);
        htmlStr = mHtml.replaceAll("");
        return htmlStr.trim();
    }
}

