/*
 *      Copyright (c) 2018-2028, Chill Zhuang All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *  Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *  Neither the name of the dreamlu.net developer nor the names of its
 *  contributors may be used to endorse or promote products derived from
 *  this software without specific prior written permission.
 *  Author: Chill 庄骞 (smallchill@163.com)
 */
package com.els.tso.srm.file;


import com.els.tso.common.dto.FileDTO;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

/**
 * FileTemplate抽象API
 *
 * @author Chill
 */
public interface FileTemplate {
	/**
	 * 获取文件信息
	 *
	 * @param filePath
	 * @return FileDTO
	 */
	FileDTO statFile(String filePath);
	/**
	 * 上传文件
	 *
	 * @param filePath
	 * @param file
	 * @return FileDTO
	 */
	FileDTO putFile(String filePath, MultipartFile file) throws IOException;
	/**
	 * 删除文件
	 *
	 * @param filePath
	 */
	void removeFile(String filePath);

    /**
     * 下载文件
     * @param filePath
     * @throws IOException
     */
    void downloadFile(String filePath) throws IOException;



}
