/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.srm.file;

import com.els.tso.common.dto.FileDTO;
import com.els.tso.common.exception.FileManipulaException;
import com.els.tso.srm.file.FileTemplate;
import com.els.tso.srm.model.MultipartFileParam;
import com.els.tso.srm.service.FileChunkUploadService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Component(value="fileLocalTemplate")
public class FileLocalTemplate
implements FileTemplate {
    @Autowired
    private FileChunkUploadService fileChunkUploadService;
    @Value(value="${els.srm.system.file-path}")
    private String systemPath;

    @Override
    public FileDTO statFile(String filePath) {
        String realFilePath = this.systemPath + "/" + filePath;
        File file = new File(realFilePath);
        if (!file.exists()) {
            throw new FileManipulaException("\u672a\u627e\u5230\u6587\u4ef6");
        }
        return this.getFileDto(file);
    }

    @Override
    public FileDTO putFile(String fileName, MultipartFile file) throws IOException {
        if (file == null) {
            return null;
        }
        MultipartFileParam multipartFileParam = this.getMultipartFileParam(file);
        multipartFileParam = this.fileChunkUploadService.fileChunkUpload(multipartFileParam, fileName);
        return this.getFileDTO(multipartFileParam);
    }

    @Override
    public void removeFile(String filePath) {
        String realFilePath = this.systemPath + "/" + filePath;
        File file = new File(realFilePath);
        if (!file.exists()) {
            throw new FileManipulaException("\u672a\u627e\u5230\u6587\u4ef6");
        }
        boolean delete = file.delete();
        if (!delete) {
            throw new FileManipulaException("\u6587\u4ef6\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void downloadFile(String filePath) throws IOException {
        String realFilePath = this.systemPath + "/" + filePath;
        File file = new File(realFilePath);
        if (!file.exists()) {
            throw new FileManipulaException("\u672a\u627e\u5230\u6587\u4ef6");
        }
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        try (FileInputStream inStream = new FileInputStream(file);
             ServletOutputStream outStream = response.getOutputStream();){
            int readLength;
            byte[] buf = new byte[4096];
            while ((readLength = ((InputStream)inStream).read(buf)) != -1) {
                outStream.write(buf, 0, readLength);
            }
        }
    }

    private FileDTO getFileDto(File file) {
        FileDTO fileDTO = new FileDTO();
        fileDTO.setName(file.getName());
        fileDTO.setType(this.fileChunkUploadService.getFileExt(file.getName()));
        fileDTO.setPutTime(new Date(this.getFileCreateTime(file.getPath())));
        String filePath = file.getPath();
        fileDTO.setLink(filePath.replace(this.systemPath.replaceAll("/", "\\\\"), ""));
        fileDTO.setLength(file.length());
        return fileDTO;
    }

    private Long getFileCreateTime(String filePath) {
        File file = new File(filePath);
        try {
            Path path = Paths.get(filePath, new String[0]);
            BasicFileAttributeView basicview = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
            BasicFileAttributes attr = basicview.readAttributes();
            return attr.creationTime().toMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
            return file.lastModified();
        }
    }

    private MultipartFileParam getMultipartFileParam(MultipartFile file) throws IOException {
        long size = file.getSize();
        String filename = file.getOriginalFilename();
        MultipartFileParam multipartFileParam = new MultipartFileParam();
        multipartFileParam.setAttachment(file.getInputStream());
        multipartFileParam.setIdentifier(size + "-" + this.fileChunkUploadService.getFileExt(filename));
        multipartFileParam.setTotalSize((int)size);
        multipartFileParam.setFilename(filename);
        multipartFileParam.setChunkSize(size);
        multipartFileParam.setChunkNumber(1);
        multipartFileParam.setCurrentChunkSize(size);
        multipartFileParam.setTotalChunks(1);
        return multipartFileParam;
    }

    private FileDTO getFileDTO(MultipartFileParam multipartFileParam) {
        FileDTO fileDTO = new FileDTO();
        fileDTO.setLength((long)multipartFileParam.getTotalSize());
        fileDTO.setLink(multipartFileParam.getFileStorePath());
        fileDTO.setName(multipartFileParam.getFilename());
        fileDTO.setPutTime(new Date());
        fileDTO.setType(this.fileChunkUploadService.getFileExt(fileDTO.getName()));
        return fileDTO;
    }
}

