/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.srm.service.impl;

import com.els.tso.base.service.RedisCacheService;
import com.els.tso.common.exception.BusinessException;
import com.els.tso.common.util.IdWorker;
import com.els.tso.srm.configuration.SrmSystemConfig;
import com.els.tso.srm.model.MultipartFileParam;
import com.els.tso.srm.service.FileChunkUploadService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.assertj.core.util.Sets;
import org.springframework.stereotype.Service;

@Service
public class FileChunkUploadServiceImpl
implements FileChunkUploadService {
    private static final Pattern PATTERN = Pattern.compile("\\s|'");
    private final RedisCacheService redisCacheService;
    private final SrmSystemConfig systemConfig;

    public FileChunkUploadServiceImpl(RedisCacheService redisCacheService, SrmSystemConfig systemConfig) {
        this.redisCacheService = redisCacheService;
        this.systemConfig = systemConfig;
    }

    @Override
    public MultipartFileParam fileChunkUpload(MultipartFileParam multipartFileParam, String userId) throws IOException {
        this.redisCacheService.hset(multipartFileParam.getIdentifier(), multipartFileParam.getChunkNumber() + "", IOUtils.toByteArray((InputStream)multipartFileParam.getAttachment()));
        if (this.redisCacheService.hlen(multipartFileParam.getIdentifier()) == (long)multipartFileParam.getTotalChunks()) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                for (int i = 1; i <= multipartFileParam.getTotalChunks(); ++i) {
                    byte[] bytes = (byte[])this.redisCacheService.hget(multipartFileParam.getIdentifier(), i + "");
                    byteArrayOutputStream.write(bytes, 0, bytes.length);
                }
                String fileName = multipartFileParam.getFilename();
                String fileNewName = this.getNewFileName(fileName);
                String savePath = this.getSavePath(userId, fileNewName);
                try (FileOutputStream fileOutputStream = new FileOutputStream(savePath);){
                    byte[] bytes = byteArrayOutputStream.toByteArray();
                    fileOutputStream.write(bytes);
                    fileOutputStream.flush();
                }
                multipartFileParam.setFileStorePath(savePath);
                this.redisCacheService.del(multipartFileParam.getIdentifier());
            }
        }
        multipartFileParam.setUploaded(this.getUploadedChunks(multipartFileParam.getIdentifier()));
        multipartFileParam.setAttachment(null);
        return multipartFileParam;
    }

    @Override
    public Set<Integer> getUploadedChunks(String identifier) {
        if (identifier == null) {
            throw new BusinessException("identifier\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MultipartFileParam multipartFileParam = new MultipartFileParam();
        multipartFileParam.setIdentifier(identifier);
        Map map = this.redisCacheService.hgetAll(multipartFileParam.getIdentifier());
        if (map != null) {
            return map.keySet().stream().map(key -> Integer.parseInt(key.toString())).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    @Override
    public String getFileExt(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
    }

    private String getFilePath(String elsAccount) {
        return "upload" + File.separator + elsAccount + File.separator + LocalDate.now().toString();
    }

    private String getNewFileName(String fileName) {
        String fileShortName = fileName.substring(0, fileName.lastIndexOf("."));
        Matcher matcher = PATTERN.matcher(fileShortName);
        fileShortName = matcher.replaceAll("");
        String fileExt = this.getFileExt(fileName);
        return fileShortName + "_" + IdWorker.getId() + "." + fileExt;
    }

    private String getSavePath(String elsAccount, String fileNewName) {
        String savePath = this.systemConfig.getFilePath() + this.getFilePath(elsAccount);
        File saveDirFile = new File(savePath);
        if (!saveDirFile.exists() && !saveDirFile.mkdirs()) {
            throw new BusinessException("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25,\u8bf7\u786e\u8ba4\u64cd\u4f5c\u7cfb\u7edf\u53ca\u914d\u7f6e\u53c2\u6570");
        }
        return savePath + File.separator + fileNewName;
    }
}

