/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.srm.service.impl;

import com.els.tso.base.util.TsoSpringContextHelper;
import com.els.tso.common.constant.FileUploadEnum;
import com.els.tso.common.dto.FileDTO;
import com.els.tso.srm.file.FileTemplate;
import com.els.tso.srm.service.FileManipulaService;
import java.io.IOException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileManipulaServiceImpl
implements FileManipulaService,
InitializingBean,
ApplicationRunner {
    @Value(value="${els.srm.system.file-way}")
    private String fileSaveWay;
    private static String wayBeanName;
    private static FileTemplate fileTemplate;

    public void afterPropertiesSet() throws Exception {
        FileUploadEnum[] values;
        for (FileUploadEnum value : values = FileUploadEnum.values()) {
            if (!value.getName().equals(this.fileSaveWay)) continue;
            wayBeanName = value.getBeanName();
            break;
        }
    }

    @Override
    public FileDTO statFile(String filePath) {
        return fileTemplate.statFile(filePath);
    }

    @Override
    public FileDTO putFile(String filePath, MultipartFile file) throws IOException {
        return fileTemplate.putFile(filePath, file);
    }

    @Override
    public void removeFile(String filePath) {
        fileTemplate.removeFile(filePath);
    }

    @Override
    public void downloadFile(String filePath) throws IOException {
        fileTemplate.downloadFile(filePath);
    }

    public void run(ApplicationArguments args) throws Exception {
        fileTemplate = (FileTemplate)TsoSpringContextHelper.getBean((String)wayBeanName);
    }
}

