package com.els.tso.srm.service.impl;

import com.els.tso.base.util.TsoSpringContextHelper;
import com.els.tso.common.dto.FileDTO;
import com.els.tso.common.constant.FileUploadEnum;
import com.els.tso.srm.file.FileTemplate;
import com.els.tso.srm.service.FileManipulaService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

@Service
public class FileManipulaServiceImpl implements FileManipulaService, InitializingBean, ApplicationRunner {
    @Value("${els.srm.system.file-way}")
    private String fileSaveWay;
    private static String wayBeanName;
    private static FileTemplate fileTemplate;

    @Override
    public void afterPropertiesSet() throws Exception {
        FileUploadEnum[] values = FileUploadEnum.values();
        for (FileUploadEnum value : values) {
            if (value.getName().equals(fileSaveWay)) {
                wayBeanName = value.getBeanName();
                break;
            }
        }
    }

    @Override
    public FileDTO statFile(String filePath) {
        return fileTemplate.statFile(filePath);
    }

    @Override
    public FileDTO putFile(String filePath, MultipartFile file) throws IOException {
        return fileTemplate.putFile(filePath, file);
    }

    @Override
    public void removeFile(String filePath) {
        fileTemplate.removeFile(filePath);
    }

    @Override
    public void downloadFile(String filePath) throws IOException {
        fileTemplate.downloadFile(filePath);
    }


    @Override
    public void run(ApplicationArguments args) throws Exception {

        fileTemplate = TsoSpringContextHelper.getBean(wayBeanName);
    }
}
