package com.els.tso.sso.controller;

import com.els.tso.sso.util.ThreadLocalUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author daipj
 * @date 2020/10/22 15:34
 */
@RestController
public class CasTestController {

    private final static Logger LOGGER = LoggerFactory.getLogger(CasTestController.class);

    @GetMapping("/hello/index")
    public String t1() {

        return "hello world! ";
    }

    @GetMapping("/cas/index")
    public String t2() {

        String userCode = null;
        try {
            if (ThreadLocalUser.getUser() != null) {
                userCode = ThreadLocalUser.getUser().getUserCode();
            }
        } finally {
            ThreadLocalUser.remove();
        }
        return "hello " + userCode;
    }
}
