package com.els.tso.sso.configuration;

import com.els.tso.common.entity.User;
import com.els.tso.common.util.AuthPrincipalHolder;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.util.AssertionHolder;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import javax.servlet.*;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author daipj
 */
@Configuration
@ConditionalOnClass({AuthenticationFilter.class, AssertionThreadLocalFilter.class})
@Import(CasProperties.class)
public class SsoServletAndFilterAndListenerConfiguration {


    private final List<String> urlPatterns;
    private final CasProperties casProperties;

    public SsoServletAndFilterAndListenerConfiguration(CasProperties casProperties) {
        this.casProperties = casProperties;
        urlPatterns = casProperties.getUrlPatterns();
    }

    private Map<String, String> casConfig() {
        Map<String, String> map = new HashMap<>(16);
        map.put("casServerUrlPrefix", casProperties.getCasServerUrlPrefix());
        map.put("service", casProperties.getService());
        map.put("serverName", casProperties.getServerName());
        map.put("casServerLoginUrl", casProperties.getCasServerLoginUrl());
        return map;
    }

    @Bean
    public ServletListenerRegistrationBean<SingleSignOutHttpSessionListener> singleSignOutHttpSessionListener() {

        return new ServletListenerRegistrationBean<>(new SingleSignOutHttpSessionListener());
    }

    /**
     * @return
     */
    @Bean
    public FilterRegistrationBean<SingleSignOutFilter> singleSignOutRegistrationBean() {

        FilterRegistrationBean<SingleSignOutFilter> singleSignOutFilterFilterRegistrationBean = new FilterRegistrationBean<>(new SingleSignOutFilter());
        singleSignOutFilterFilterRegistrationBean.setUrlPatterns(urlPatterns);
        return singleSignOutFilterFilterRegistrationBean;
    }

    /**
     * @return
     */
    @Bean
    public FilterRegistrationBean<AuthenticationFilter> authenticationFilterRegistrationBean() {

        AuthenticationFilter authenticationFilter = new AuthenticationFilter();
        FilterRegistrationBean<AuthenticationFilter> authenticationFilterFilterRegistrationBean = new FilterRegistrationBean<>(authenticationFilter);
        authenticationFilterFilterRegistrationBean.setInitParameters(this.casConfig());
        authenticationFilterFilterRegistrationBean.setUrlPatterns(urlPatterns);
        authenticationFilterFilterRegistrationBean.setOrder(10);
        return authenticationFilterFilterRegistrationBean;
    }

    /**
     * @return
     */
    @Bean
    public FilterRegistrationBean<Cas20ProxyReceivingTicketValidationFilter> ticketValidationBeanRegistrationBean() {

        Cas20ProxyReceivingTicketValidationFilter cas20ProxyReceivingTicketValidationFilter = new Cas20ProxyReceivingTicketValidationFilter();
        FilterRegistrationBean<Cas20ProxyReceivingTicketValidationFilter> ticketValidationRegistrationBean = new FilterRegistrationBean<>(cas20ProxyReceivingTicketValidationFilter);
        ticketValidationRegistrationBean.setInitParameters(this.casConfig());
        ticketValidationRegistrationBean.setUrlPatterns(urlPatterns);
        ticketValidationRegistrationBean.setOrder(20);

        return ticketValidationRegistrationBean;
    }


    /**
     * @return
     */
    @Bean
    public FilterRegistrationBean<AssertionThreadLocalFilter> assertionThreadLocalFilterRegistrationBean() {

        FilterRegistrationBean<AssertionThreadLocalFilter> assertionThreadLocalFilterRegistrationBean = new FilterRegistrationBean<>(new AssertionThreadLocalFilter());
        assertionThreadLocalFilterRegistrationBean.setUrlPatterns(urlPatterns);
        assertionThreadLocalFilterRegistrationBean.setOrder(30);

        return assertionThreadLocalFilterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<UserIdFilter> userIdFilterFilterRegistrationBean() {

        FilterRegistrationBean<UserIdFilter> userIdFilterFilterRegistrationBean = new FilterRegistrationBean<>(new UserIdFilter());
        userIdFilterFilterRegistrationBean.setUrlPatterns(urlPatterns);
        userIdFilterFilterRegistrationBean.setOrder(40);
        return userIdFilterFilterRegistrationBean;
    }

    /**
     * RestTemplate
     * 超时10s
     *
     * @return
     */
    @Bean
    public RestTemplate restTemplate() {

        //10s
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(10 * 1000);
        requestFactory.setReadTimeout(10 * 1000);
        return new RestTemplate(requestFactory);
    }

    static class UserIdFilter implements Filter {

        private final static Logger LOGGER = LoggerFactory.getLogger(UserIdFilter.class);

        @Override
        public void init(FilterConfig filterConfig) {

        }

        @Override
        public void destroy() {

        }

        @Override
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {

            final Assertion assertion = AssertionHolder.getAssertion();
            if (null != assertion) {
                String userCode = assertion.getPrincipal().getName();
                if (!StringUtils.isEmpty(userCode)) {
                    AuthPrincipalHolder.setUser(new User(userCode));
                }

            }
            chain.doFilter(servletRequest, servletResponse);
        }
    }
}
