package com.els.tso.util.service.impl;

import com.els.tso.util.dao.ColumnsMapper;
import com.els.tso.util.pojo.bo.CopyTableBO;
import com.els.tso.util.pojo.entity.ColumnsEntity;
import com.els.tso.util.pojo.query.TableDataCopyQuery;
import com.els.tso.util.service.CopyByElsAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * @author ASUS
 */
@Service
public class CopyByElsAccountServiceImpl implements CopyByElsAccountService {

    private static final Logger LOGGER = LoggerFactory.getLogger(CopyByElsAccountServiceImpl.class);

    private static final String ELS_ACCOUNT = "elsAccount";
    private static final String UUID = "uuid";
    private static final String ID = "id";
    private static final String UUID_FUNCTION = "UUID()";

    @Resource
    private ColumnsMapper columnsMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void tableDataCopy(TableDataCopyQuery query) {

        List<ColumnsEntity> columnsEntities = columnsMapper.selectColumnsByTableName(query.getTableSchema(), query.getTableName());
        MultiValueMap<String, ColumnsEntity> map = new LinkedMultiValueMap<>(32);
        columnsEntities.forEach(co -> {
            map.add(co.getTableName(), co);
        });
        map.forEach((key, value) -> {
            StringBuilder columnBuilder = new StringBuilder();
            StringBuilder valueBuilder = new StringBuilder();
            value.forEach(column -> {
                //跳过id自增字段
                if(!ID.equalsIgnoreCase(column.getColumnName())){

                    columnBuilder.append(",");
                    valueBuilder.append(",");
                    columnBuilder.append("`");
                    columnBuilder.append(column.getColumnName());
                    columnBuilder.append("`");
                    if (ELS_ACCOUNT.equalsIgnoreCase(column.getColumnName())) {
                        valueBuilder.append("\"")
                            .append(query.getToElsAccount())
                            .append("\"");
                    } else if (UUID.equalsIgnoreCase(column.getColumnName())) {
                        valueBuilder.append(UUID_FUNCTION);
                    } else {
                        valueBuilder.append("`");
                        valueBuilder.append(column.getColumnName());
                        valueBuilder.append("`");
                    }
                }
            });
            String columnStr = columnBuilder.toString().substring(1);
            String valueStr = valueBuilder.toString().substring(1);

            CopyTableBO copyTable = new CopyTableBO();
            copyTable.setTableName(key);
            copyTable.setColumnStr(columnStr);
            copyTable.setValueStr(valueStr);
            copyTable.setFromElsAccount(query.getFromElsAccount());
            copyTable.setToElsAccount(query.getToElsAccount());
            copyTable.setTableSchema(query.getTableSchema());
            columnsMapper.copyTableData(copyTable);
        });
        CopyTableBO copyTable = new CopyTableBO();
        copyTable.setFromElsAccount(query.getFromElsAccount());
        copyTable.setToElsAccount(query.getToElsAccount());
        columnsMapper.menuCopy(copyTable);

        String updateSql = " update enterprise_info\n" +
            "        set toElsAccount = #{toElsAccount},\n" +
            "            fullName     = #{enterpriseName},\n" +
            "            shortName    = #{enterpriseName}\n" +
            "        where elsAccount = #{toElsAccount};\n" +
            "        update els_app\n" +
            "        set appUrl = 'http://cs.51qqt.com/" + query.getAppContext() + "/uflo/designer'\n" +
            "        where elsAccount = #{toElsAccount}\n" +
            "          and appCode = 'uflo_designer';";
        CopyTableBO copyTable2 = new CopyTableBO();
        copyTable2.setFromElsAccount(query.getFromElsAccount());
        copyTable2.setToElsAccount(query.getToElsAccount());
        copyTable2.setUpdateSql(updateSql);
        copyTable2.setAppContext(query.getAppContext());
        copyTable2.setEnterpriseName(query.getEnterpriseName());
        columnsMapper.executeUpdateSql(copyTable2);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void tableDataClear(TableDataCopyQuery query) {

        Arrays.asList(query.getTableName()).forEach(tableName -> {

            CopyTableBO copyTable = new CopyTableBO();
            copyTable.setToElsAccount(query.getToElsAccount());
            copyTable.setTableName(tableName);
            columnsMapper.clearTableData(copyTable);
        });
    }

}
