package com.els.tso.workflow.dto;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.activiti.engine.task.DelegationState;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ASUS
 */
@ToString
@Setter
@Getter
public class TaskOutDTO implements Serializable {

    private static final long serialVersionUID = 1869788875852118842L;
    private String id;
    private String owner;
    private String assignee;
    private DelegationState delegationState;

    private String parentTaskId;

    private String name;
    private String description;
    private Integer priority;
    /**
     * The time when the task has been created
     */
    private Date createTime;
    private Date dueDate;

    private String processInstanceId;

    private String formKey;
    /**
     * 业务主键
     */
    private String businessKey;
    /**
     * 审批状态
     */
    private String state;
    /**
     * 审批意见
     */
    private String opinion;

}
