package com.els.tso.workflow.enumeration;

/**
 * @author zm
 * <p>
 * 审批状态
 */
public enum AuditStatusEnum {

    /**
     * 审批状态
     */
    AUDIT_PASS(0, "审批通过"), UN_AUDIT(1, "未审批"), IN_AUDIT(2, "审批中"), AUDIT_NOPASS(3, "审批拒绝"),AUDIT_CANCEL(4, "审批撤回"),
    /**
     * 错误
     */
    AUDIT_ERROR(-1, "错误"), AUDIT_LAST_ERROR(-2, "只有上一级处理人才能撤销审批"), AUDIT_NOT_ERROR(-3, "无法撤销审批，下级审批人已经审核审批"), AUDIT_CANCEL_ERROR(-4, "无法撤销审批，检查这条审批单是否处于分支节点"), AUDIT_CANCEL2_ERROR(-5, "无法撤销审批，请检查单据是否还在审批中"), AUDIT_TERMINATE(-6, "终止流程");
    private final Integer value;

    private final String desc;

    /**
     * @param value
     * @param desc
     */
    AuditStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
