package com.els.tso.workflow.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * @author daipj
 * @date 2020/9/25 9:41
 */
public class ActivitiResultMO implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 流程实例根id,每发起一个流程就会产生
     */
    private String processInstanceId;
    /**
     * 审批状态，操作完成后 返回审批状态(0, "审批通过", 1, "未审批", 2, "审批中", 3, "审批拒绝")
     */
    private int auditStatus;
    /**
     * 提交审批人elsAccount_elsSubAccount
     */
    private String submitUser;
    /**
     * 当前提交人(submitUser)的下一级任务id
     */
    private String nextTaskId;

    /**
     * 下一层级需要审批人列表，用于发送消息提醒 格式[elsAccount_elsSubAccount,elsAccount_elsSubAccount]
     */
    private Set<String> nextAuditUserList = new HashSet<>();

    public String getProcessInstanceId() {
        return processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public int getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(int auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getSubmitUser() {
        return submitUser;
    }

    public void setSubmitUser(String submitUser) {
        this.submitUser = submitUser;
    }

    public String getNextTaskId() {
        return nextTaskId;
    }

    public void setNextTaskId(String nextTaskId) {
        this.nextTaskId = nextTaskId;
    }

    public Set<String> getNextAuditUserList() {
        return nextAuditUserList;
    }

    public void setNextAuditUserList(Set<String> nextAuditUserList) {
        this.nextAuditUserList = nextAuditUserList;
    }
}
