package com.els.tso.workflow.service;

import com.els.tso.workflow.model.ActivitiResultMO;
import com.els.tso.workflow.dto.TaskOutDTO;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * Activiti相关操作
 *
 * @author wyssss
 * @since 2020/04/22
 */
public interface ActivitiOptService {


    ActivitiResultMO submit(String processDefinitionKey, String userId, String businessKey, String auditOpinion, Map<String, Object> variables);

    ActivitiResultMO complete(String taskId, String userId, String auditOpinion, Map<String, Object> variables);

    ActivitiResultMO refuse(String taskId, String userId, String auditOpinion);

    ActivitiResultMO reject(String taskId, String userId, String auditOpinion);

    boolean isFlowNodeJustBefore(String taskId);

    boolean isJustSubmit(String processInstanceId);

    InputStream showDiagram(String processInstanceId);

    String createUser(String userId, String userName);

    String createUserGroup(String groupId, String groupName, String userId);

    /**
     * 待办列表
     *
     * @param userId
     * @return
     */
    List<TaskOutDTO> todoList(String userId);

    /**
     * 可分页的代办列表
     *
     * @param userId
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<TaskOutDTO> todoPageList(String userId, int pageNum, int pageSize);

    List<TaskOutDTO> auditHisList(String processInstanceId);

    /**
     * 代办数量
     *
     * @param userId
     * @return
     */
    long todoListCount(String userId);

    ActivitiResultMO cancelSubmit(String userId, String processInstanceId, String auditOpinion);

    ActivitiResultMO cancelComplete(String userId, String taskId, String auditOpinion);
}
