package com.els.tso.workflow.service;

import org.activiti.engine.runtime.ProcessInstance;

import java.util.Map;

/**
 * @author daipj
 */
public interface WorkFlowService {

    /**
     * 开启流程
     *
     * @param processDefinitionKey
     * @param businessKey
     * @param processVariable      设置在流程里面的参数
     * @return
     */
    ProcessInstance startProcess(String processDefinitionKey, String businessKey,
                                 Map<String, Object> processVariable);

    /**
     * 停止流程
     *
     * @return
     */
    ProcessInstance stopProcess(String processDefinitionKey, String businessKey);

    /**
     * 审批流程
     *
     * @param taskId
     * @param userId
     * @param isPass
     * @param desc
     */
    void completePersonalTask(String taskId, String userId, String isPass, String desc);

}
