/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.workflow.service.impl;

import com.els.tso.workflow.dto.TaskOutDTO;
import com.els.tso.workflow.enumeration.AuditCommentTypeEnum;
import com.els.tso.workflow.enumeration.AuditStatusEnum;
import com.els.tso.workflow.model.ActivitiResultMO;
import com.els.tso.workflow.service.ActivitiOptService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.history.ProcessInstanceHistoryLog;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.impl.DefaultProcessDiagramGenerator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ActivitiOptServiceImpl
implements ActivitiOptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivitiOptServiceImpl.class);
    @Autowired
    protected FormService formService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ManagementService managerService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private IdentityService identityService;

    @Override
    public ActivitiResultMO submit(String processDefinitionKey, String userId, String businessKey, String auditOpinion, Map<String, Object> variables) {
        Assert.hasLength((String)processDefinitionKey, (String)"processDefinitionKey\u4e0d\u80fd\u4e3a\u7a7a");
        ActivitiResultMO result = new ActivitiResultMO();
        this.identityService.setAuthenticatedUserId(userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, variables);
        if (StringUtils.isNotBlank((CharSequence)auditOpinion)) {
            processInstance.getProcessVariables().put("submit_opinion", auditOpinion);
        }
        result.setProcessInstanceId(processInstance.getProcessInstanceId());
        result.setAuditStatus(AuditStatusEnum.IN_AUDIT.getValue());
        result.setSubmitUser(userId);
        List<Task> tasks = this.getProcessTasks(processInstance.getProcessInstanceId());
        if (tasks != null) {
            Set<String> auditUserList = tasks.parallelStream().map(TaskInfo::getAssignee).collect(Collectors.toSet());
            result.setNextAuditUserList(auditUserList);
        }
        return result;
    }

    @Override
    public ActivitiResultMO complete(String taskId, String userId, String auditOpinion, Map<String, Object> variables) {
        Assert.hasLength((String)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Assert.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
        Assert.isTrue((boolean)Objects.equals(userId, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237,\u4e0d\u80fd\u64cd\u4f5c");
        String processInstanceId = task.getProcessInstanceId();
        this.taskService.claim(taskId, userId);
        if (StringUtils.isNotBlank((CharSequence)auditOpinion)) {
            this.taskService.addComment(taskId, processInstanceId, AuditCommentTypeEnum.OPINION.getType(), auditOpinion);
        }
        this.taskService.addComment(taskId, processInstanceId, AuditCommentTypeEnum.STATE.getType(), AuditStatusEnum.AUDIT_PASS.getDesc());
        this.taskService.complete(taskId, variables);
        List<Task> tasks = this.getProcessTasks(processInstanceId);
        ActivitiResultMO result = new ActivitiResultMO();
        result.setProcessInstanceId(processInstanceId);
        result.setSubmitUser(userId);
        if (tasks == null || tasks.size() == 0) {
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            String startUserId = processInstance.getStartUserId();
            result.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getValue());
            result.setNextAuditUserList(Collections.singleton(startUserId));
        } else {
            result.setAuditStatus(AuditStatusEnum.IN_AUDIT.getValue());
            Set<String> auditUserList = tasks.parallelStream().map(TaskInfo::getAssignee).collect(Collectors.toSet());
            result.setNextAuditUserList(auditUserList);
        }
        return result;
    }

    @Override
    public ActivitiResultMO refuse(String taskId, String userId, String auditOpinion) {
        Assert.hasLength((String)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        Assert.notNull((Object)task, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
        Assert.isTrue((boolean)Objects.equals(userId, task.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237,\u4e0d\u80fd\u64cd\u4f5c");
        String processInstanceId = task.getProcessInstanceId();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        String startUserId = processInstance.getStartUserId();
        this.taskService.addComment(taskId, processInstanceId, AuditCommentTypeEnum.STATE.getType(), AuditStatusEnum.AUDIT_NOPASS.getDesc());
        this.taskService.addComment(taskId, processInstanceId, AuditCommentTypeEnum.OPINION.getType(), auditOpinion);
        this.runtimeService.deleteProcessInstance(processInstanceId, auditOpinion);
        ActivitiResultMO result = new ActivitiResultMO();
        result.setProcessInstanceId(processInstanceId);
        result.setSubmitUser(userId);
        result.setAuditStatus(AuditStatusEnum.AUDIT_NOPASS.getValue());
        result.setNextAuditUserList(Collections.singleton(startUserId));
        return result;
    }

    @Override
    public ActivitiResultMO reject(String taskId, String userId, String auditOpinion) {
        return null;
    }

    @Override
    public ActivitiResultMO cancelSubmit(String userId, String processInstanceId, String auditOpinion) {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.notNull((Object)historicProcessInstance, (String)"\u5f53\u524d\u6d41\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
        String startUserId = historicProcessInstance.getStartUserId();
        Assert.isTrue((boolean)Objects.equals(userId, startUserId), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237,\u4e0d\u80fd\u64cd\u4f5c");
        this.identityService.setAuthenticatedUserId(userId);
        this.runtimeService.deleteProcessInstance(processInstanceId, auditOpinion);
        return this.getActivitiResultMO(taskList, userId, processInstanceId, AuditStatusEnum.UN_AUDIT);
    }

    @Override
    public ActivitiResultMO cancelComplete(String userId, String taskId, String auditOpinion) {
        Assert.hasLength((String)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        Assert.notNull((Object)historicTaskInstance, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
        Assert.isTrue((boolean)Objects.equals(userId, historicTaskInstance.getAssignee()), (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237,\u4e0d\u80fd\u64cd\u4f5c");
        String processInstanceId = historicTaskInstance.getProcessInstanceId();
        String myActivityId = null;
        List haiList = this.historyService.createHistoricActivityInstanceQuery().executionId(historicTaskInstance.getExecutionId()).finished().list();
        for (HistoricActivityInstance hai : haiList) {
            if (!taskId.equals(hai.getTaskId())) continue;
            myActivityId = hai.getActivityId();
            break;
        }
        Assert.notNull(myActivityId, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
        FlowNode myFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(myActivityId);
        List list = ((TaskQuery)this.taskService.createTaskQuery().executionId(historicTaskInstance.getExecutionId())).list();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(historicTaskInstance.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode flowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        ArrayList oriSequenceFlows = new ArrayList(flowNode.getOutgoingFlows());
        flowNode.getOutgoingFlows().clear();
        ArrayList<SequenceFlow> newSequenceFlowList = new ArrayList<SequenceFlow>();
        SequenceFlow newSequenceFlow = new SequenceFlow();
        newSequenceFlow.setSourceFlowElement((FlowElement)flowNode);
        newSequenceFlow.setTargetFlowElement((FlowElement)myFlowNode);
        newSequenceFlowList.add(newSequenceFlow);
        flowNode.setOutgoingFlows(newSequenceFlowList);
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        list.forEach(taskTmp -> {
            this.identityService.setAuthenticatedUserId(userId);
            if (StringUtils.isNotBlank((CharSequence)auditOpinion)) {
                this.taskService.addComment(taskTmp.getId(), taskTmp.getProcessInstanceId(), AuditCommentTypeEnum.OPINION.getType(), auditOpinion);
            }
            this.taskService.addComment(taskTmp.getId(), taskTmp.getProcessInstanceId(), AuditCommentTypeEnum.STATE.getType(), AuditStatusEnum.AUDIT_CANCEL.getDesc());
            this.taskService.complete(taskTmp.getId());
        });
        flowNode.setOutgoingFlows(oriSequenceFlows);
        return this.getActivitiResultMO(taskList, userId, processInstanceId, AuditStatusEnum.IN_AUDIT);
    }

    @Override
    public boolean isFlowNodeJustBefore(String taskId) {
        Assert.hasLength((String)taskId, (String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        Assert.notNull((Object)historicTaskInstance, (String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
        List haiList = this.historyService.createHistoricActivityInstanceQuery().executionId(historicTaskInstance.getExecutionId()).list();
        String myActivityId = null;
        for (HistoricActivityInstance hai : haiList) {
            if (!taskId.equals(hai.getTaskId())) continue;
            myActivityId = hai.getActivityId();
            break;
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(historicTaskInstance.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode myFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(myActivityId);
        FlowNode flowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        AtomicBoolean check = new AtomicBoolean(false);
        myFlowNode.getOutgoingFlows().forEach(outFlow -> flowNode.getIncomingFlows().forEach(inFlow -> {
            if (outFlow == inFlow) {
                check.set(true);
            }
        }));
        return check.get();
    }

    @Override
    public boolean isJustSubmit(String processInstanceId) {
        Assert.hasLength((String)processInstanceId, (String)"processInstanceId\u4e0d\u80fd\u4e3a\u7a7a");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        Assert.notNull((Object)historicProcessInstance, (String)"\u5f53\u524d\u6d41\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());
        FlowNode myFlowNode = (FlowNode)bpmnModel.getMainProcess().getInitialFlowElement();
        AtomicBoolean allCheck = new AtomicBoolean(true);
        List list = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (Task task : list) {
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
            FlowNode flowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(execution.getActivityId());
            AtomicBoolean check = new AtomicBoolean(false);
            myFlowNode.getOutgoingFlows().forEach(outFlow -> flowNode.getIncomingFlows().forEach(inFlow -> {
                if (outFlow == inFlow) {
                    check.set(true);
                }
            }));
            if (check.get()) continue;
            allCheck.set(false);
            break;
        }
        return allCheck.get();
    }

    @Override
    public InputStream showDiagram(String processInstanceId) {
        return this.getProcessDiagram(processInstanceId);
    }

    @Override
    public String createUser(String userId, String userName) {
        User userOld = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        if (userOld != null) {
            this.identityService.deleteUser(userId);
        }
        User user = this.identityService.newUser(userId);
        user.setFirstName(userName);
        this.identityService.saveUser(user);
        return userId;
    }

    @Override
    public String createUserGroup(String groupId, String groupName, String userId) {
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            Group groupNew = this.identityService.newGroup(groupId);
            groupNew.setName(groupName);
            this.identityService.saveGroup(groupNew);
        }
        if (this.identityService.createUserQuery().userId(userId).singleResult() != null) {
            this.identityService.createMembership(userId, groupId);
        } else {
            LOGGER.warn("userId\u5728activiti\u7528\u6237\u8868\u4e2d\u4e0d\u5b58\u5728,userId\u5173\u8054\u5728group\u5ffd\u7565");
        }
        return groupId;
    }

    private List<Task> getProcessTasks(String processInstanceId) {
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
    }

    @Override
    public List<TaskOutDTO> todoList(String userId) {
        return this.todoPageList(userId, 1, Integer.MAX_VALUE);
    }

    @Override
    public List<TaskOutDTO> todoPageList(String userId, int pageNum, int pageSize) {
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(userId)).orderByTaskCreateTime()).desc()).listPage((pageNum - 1) * pageSize, pageSize);
        return tasks.parallelStream().map(this::converse).collect(Collectors.toList());
    }

    @Override
    public List<TaskOutDTO> auditHisList(String processInstanceId) {
        ProcessInstanceHistoryLog historyLog = this.historyService.createProcessInstanceHistoryLogQuery(processInstanceId).includeActivities().includeComments().singleResult();
        Assert.notNull((Object)historyLog, (String)"\u5f53\u524d\u6d41\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
        ArrayList<TaskOutDTO> list = new ArrayList<TaskOutDTO>();
        TaskOutDTO start = new TaskOutDTO();
        list.add(start);
        start.setAssignee(historyLog.getStartUserId());
        start.setCreateTime(historyLog.getStartTime());
        start.setState("\u63d0\u4ea4\u5ba1\u6279");
        historyLog.getHistoricData().forEach(log -> {
            HistoricActivityInstance historicActivityInstance;
            if (log instanceof HistoricActivityInstance && "userTask".equals((historicActivityInstance = (HistoricActivityInstance)log).getActivityType()) && historicActivityInstance.getEndTime() != null) {
                TaskOutDTO outDTO = new TaskOutDTO();
                list.add(outDTO);
                outDTO.setAssignee(historicActivityInstance.getAssignee());
                outDTO.setCreateTime(historicActivityInstance.getEndTime());
                outDTO.setId(historicActivityInstance.getTaskId());
                if (StringUtils.isNotBlank((CharSequence)historicActivityInstance.getDeleteReason())) {
                    outDTO.setOpinion(historicActivityInstance.getDeleteReason());
                    outDTO.setState(AuditStatusEnum.AUDIT_CANCEL.getDesc());
                }
            }
        });
        list.forEach(dto -> historyLog.getHistoricData().forEach(log -> {
            if (log instanceof Comment) {
                Comment comment = (Comment)log;
                if (dto.getId() != null && dto.getId().equals(comment.getTaskId())) {
                    if (AuditCommentTypeEnum.STATE.getType().equals(comment.getType())) {
                        dto.setState(comment.getFullMessage());
                    } else {
                        dto.setOpinion(comment.getFullMessage());
                    }
                }
            }
        }));
        return list;
    }

    private TaskOutDTO converse(Task task) {
        TaskOutDTO outDTO = new TaskOutDTO();
        outDTO.setId(task.getId());
        outDTO.setAssignee(task.getAssignee());
        outDTO.setCreateTime(task.getCreateTime());
        outDTO.setDelegationState(task.getDelegationState());
        outDTO.setDescription(task.getDescription());
        outDTO.setDueDate(task.getDueDate());
        outDTO.setFormKey(task.getFormKey());
        outDTO.setName(task.getName());
        outDTO.setParentTaskId(task.getParentTaskId());
        outDTO.setPriority(task.getPriority());
        outDTO.setProcessInstanceId(task.getProcessInstanceId());
        outDTO.setOwner(task.getOwner());
        String businessKey = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getBusinessKey();
        outDTO.setBusinessKey(businessKey);
        return outDTO;
    }

    @Override
    public long todoListCount(String userId) {
        return ((TaskQuery)this.taskService.createTaskQuery().taskAssignee(userId)).count();
    }

    public InputStream getProcessDiagram(String processInstanceId) {
        String processDefinitionId;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        List activeActivityIds = Collections.emptyList();
        if (processInstance != null) {
            activeActivityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
            processDefinitionId = processInstance.getProcessDefinitionId();
        } else {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            Assert.notNull((Object)historicProcessInstance, (String)"\u5f53\u524d\u6d41\u7a0b\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210,\u8bf7\u786e\u8ba4");
            processDefinitionId = historicProcessInstance.getProcessDefinitionId();
        }
        BpmnModel model = this.repositoryService.getBpmnModel(processDefinitionId);
        if (model.getLocationMap().size() > 0) {
            DefaultProcessDiagramGenerator generator = new DefaultProcessDiagramGenerator();
            return generator.generateDiagram(model, "jpeg", activeActivityIds, Collections.emptyList(), "\u5b8b\u4f53,SimSun", "\u5b8b\u4f53,SimSun", "\u5b8b\u4f53,SimSun", null, 1.0);
        }
        return null;
    }

    private ActivitiResultMO getActivitiResultMO(List<Task> taskList, String userId, String processInstanceId, AuditStatusEnum unAudit) {
        ActivitiResultMO result = new ActivitiResultMO();
        result.setProcessInstanceId(processInstanceId);
        result.setSubmitUser(userId);
        result.setAuditStatus(unAudit.getValue());
        result.setNextAuditUserList(taskList.stream().map(TaskInfo::getAssignee).collect(Collectors.toSet()));
        taskList.forEach(task -> {
            if (userId.equals(task.getAssignee())) {
                result.setNextTaskId(task.getId());
            }
        });
        return result;
    }
}

