/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.workflow.service.impl;

import com.els.tso.common.exception.AuditException;
import com.els.tso.workflow.service.WorkFlowService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class WorkFlowServiceImpl
implements WorkFlowService {
    @Resource
    protected TaskService taskService;
    @Resource
    protected RuntimeService runtimeService;
    @Resource
    protected HistoryService historyService;
    @Resource
    protected IdentityService identityService;
    @Resource
    protected RepositoryService repositoryService;

    @Override
    @Transactional(rollbackFor={AuditException.class})
    public void completePersonalTask(String taskId, String userId, String isPass, String desc) {
        ProcessInstance currentProcess;
        Task task = this.queryTaskAndValid(taskId);
        this.validUser(task, userId);
        if (StringUtils.isBlank((CharSequence)task.getAssignee())) {
            this.taskService.claim(taskId, userId);
        }
        if ((currentProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult()) == null || currentProcess.isEnded()) {
            throw new AuditException("\u8be5\u5ba1\u6279\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
        }
        String processDefinitionKey = (String)currentProcess.getProcessVariables().get("processDefinitionKey");
        String businessKey = currentProcess.getBusinessKey();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        if (CollectionUtils.isEmpty((Collection)processDefinitions)) {
            throw new AuditException("\u672a\u627e\u5230\u8be5\u6a21\u5757\u7f16\u7801,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list().get(processDefinitions.size() - 1);
        if (this.repositoryService.isProcessDefinitionSuspended(definition.getId())) {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).singleResult();
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "\u5ba1\u6279\u6d41\u5df2\u505c\u7528");
        } else {
            this.taskService.addComment(taskId, task.getProcessInstanceId(), desc);
            this.taskService.complete(taskId);
        }
    }

    private List<String> getUserIdByTask(Task task) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(task.getAssignee());
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        List candidateUsers = identityLinks.stream().map(IdentityLink::getUserId).collect(Collectors.toList());
        userIdList.addAll(candidateUsers);
        List userInGroups = identityLinks.stream().map(IdentityLink::getGroupId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        userIdList.addAll(userInGroups);
        return userIdList;
    }

    private void validUser(Task task, String userId) {
        if (StringUtils.isEmpty((CharSequence)task.getAssignee())) {
            ArrayList<String> list = new ArrayList<String>();
            for (IdentityLink identityLink : this.taskService.getIdentityLinksForTask(task.getId())) {
                if (!StringUtils.isNotEmpty((CharSequence)identityLink.getUserId())) continue;
                list.add(identityLink.getUserId());
            }
            if (!CollectionUtils.isEmpty(list)) {
                if (!list.contains(userId)) {
                    throw new AuditException("\u6ca1\u6709\u6743\u9650\u6267\u884c\u8be5\u5ba1\u6838\u4efb\u52a1");
                }
            } else {
                List groupList = this.identityService.createGroupQuery().groupMember(userId).list();
                ArrayList<String> groupIdList = new ArrayList<String>();
                for (Group group : groupList) {
                    groupIdList.add(group.getId());
                }
                List links = this.taskService.getIdentityLinksForTask(task.getId());
                ArrayList<String> linkGroupIds = new ArrayList<String>();
                for (IdentityLink link : links) {
                    linkGroupIds.add(link.getGroupId());
                }
                if (!CollectionUtils.containsAny(groupIdList, linkGroupIds)) {
                    throw new AuditException("\u6ca1\u6709\u6743\u9650\u6267\u884c\u8be5\u5ba1\u6838\u4efb\u52a1");
                }
            }
        } else if (!userId.equals(task.getAssignee())) {
            throw new AuditException("\u6ca1\u6709\u6743\u9650\u6267\u884c\u8be5\u5ba1\u6838\u4efb\u52a1");
        }
    }

    private Task queryTaskAndValid(String taskId) {
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId);
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new AuditException("\u8be5\u4efb\u52a1id\u4e0d\u5b58\u5728");
        }
        if (task.isSuspended()) {
            throw new AuditException("\u8be5\u5ba1\u6279\u4efb\u52a1\u5df2\u7ecf\u6682\u505c");
        }
        return task;
    }

    @Override
    public ProcessInstance stopProcess(String processDefinitionKey, String businessKey) {
        if (StringUtils.isBlank((CharSequence)processDefinitionKey) || StringUtils.isBlank((CharSequence)businessKey)) {
            throw new AuditException("\u6d41\u7a0bkey\uff0c\u4e1a\u52a1key\uff0c\u53d1\u8d77\u4eba\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        List processInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).list();
        if (CollectionUtils.isEmpty((Collection)processInstances)) {
            throw new AuditException("\u672a\u627e\u5230\u8be5\u6a21\u5757\u7f16\u7801\u6216\u4e1a\u52a1\u7f16\u7801,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        Iterator iterator = processInstances.iterator();
        if (iterator.hasNext()) {
            ProcessInstance processInstance = (ProcessInstance)iterator.next();
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "\u5df2\u4f5c\u5e9f");
            return processInstance;
        }
        return null;
    }

    @Override
    public ProcessInstance startProcess(String processDefinitionKey, String businessKey, Map<String, Object> processVariable) {
        if (StringUtils.isBlank((CharSequence)processDefinitionKey) || StringUtils.isBlank((CharSequence)businessKey)) {
            throw new AuditException("\u6d41\u7a0bkey\uff0c\u4e1a\u52a1key\uff0c\u53d1\u8d77\u4eba\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        ProcessInstance processInstance = null;
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        if (CollectionUtils.isEmpty((Collection)processDefinitions)) {
            throw new AuditException("\u672a\u627e\u5230\u8be5\u6a21\u5757\u7f16\u7801,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list().get(processDefinitions.size() - 1);
        if (!this.repositoryService.isProcessDefinitionSuspended(definition.getId())) {
            ProcessInstance currentProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).singleResult();
            if (currentProcess != null) {
                throw new AuditException("\u4e1a\u52a1\u6d41\u7a0b[" + processDefinitionKey + "][" + businessKey + "]\uff0c\u5df2\u7ecf\u542f\u52a8\uff0c\u65e0\u6cd5\u91cd\u590d\u542f\u52a8");
            }
            processVariable.put("startTime", new Date());
            processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, processVariable);
            List list = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).list();
        }
        return processInstance;
    }

    private List<Task> distinctAndSort(List<Task> allTask) {
        TreeSet<Task> taskSet = new TreeSet<Task>((t1, t2) -> t1.getId().compareTo(t2.getId()));
        taskSet.addAll(allTask);
        allTask.clear();
        allTask.addAll(taskSet);
        allTask.sort((t1, t2) -> {
            if (t1.getCreateTime() == null) {
                return -1;
            }
            if (t2.getCreateTime() == null) {
                return 1;
            }
            return t2.getCreateTime().compareTo(t1.getCreateTime());
        });
        return allTask;
    }
}

