package com.els.tso.workflow.controller;

import com.els.tso.workflow.dto.ActivitiInDTO;
import com.els.tso.workflow.service.ActivitiOptService;
import com.els.tso.common.dto.R;
import com.google.common.collect.Maps;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.*;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

@RestController
@RequestMapping("/activiti")
public class ActivitiOptController {

    private final ActivitiOptService activitiOptService;

    public ActivitiOptController(ActivitiOptService activitiOptService) {
        this.activitiOptService = activitiOptService;
    }

    @PostMapping("/submit")
    public R<?> submit(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok(activitiOptService.submit(activitiInDTO.getProcessDefinitionKey(), activitiInDTO.getUserId(),
            activitiInDTO.getBusinessKey(), activitiInDTO.getAuditOpinion(), activitiInDTO.getVariables()));

    }

    @PostMapping("/complete")
    public R<?> complete(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok(activitiOptService.complete(activitiInDTO.getTaskId(), activitiInDTO.getUserId(),
            activitiInDTO.getAuditOpinion(), activitiInDTO.getVariables()));
    }

    @PostMapping("/refuse")
    public R<?> refuse(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok(activitiOptService.refuse(activitiInDTO.getTaskId(), activitiInDTO.getUserId(),
            activitiInDTO.getAuditOpinion()));
    }

    @PostMapping("/reject")
    public R<?> reject(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok(activitiOptService.reject(activitiInDTO.getTaskId(), activitiInDTO.getUserId(),
            activitiInDTO.getAuditOpinion()));
    }

    @PostMapping("/cancel_submit")
    public R<?> cancelSubmit(@RequestBody ActivitiInDTO activitiInDTO) {

        return R.ok(activitiOptService.cancelSubmit(activitiInDTO.getUserId(), activitiInDTO.getProcessInstanceId(), activitiInDTO.getAuditOpinion()));
    }

    @PostMapping("/cancel_complete")
    public R<?> cancelComplete(@RequestBody ActivitiInDTO activitiInDTO) {

        return R.ok(activitiOptService.cancelComplete(activitiInDTO.getUserId(), activitiInDTO.getTaskId(), activitiInDTO.getAuditOpinion()));
    }

    @PostMapping("/importProcess")
    public R<?> importProcess(@RequestPart("file") MultipartFile multipartFile) {

        return R.ok(multipartFile.getName());

    }

    @GetMapping("/diagram")
    public ResponseEntity<?> showDiagram(String processInstanceId) {

        InputStream in = activitiOptService.showDiagram(processInstanceId);
        return ResponseEntity.ok()
            .contentType(MediaType.parseMediaType(MediaType.IMAGE_JPEG_VALUE))
            .body(new InputStreamResource(in));
    }

    @GetMapping("/diagram1")
    public ResponseEntity<?> showDiagram1(String processInstanceId) throws IOException {

        HttpHeaders headers = new HttpHeaders();
        InputStream in = activitiOptService.showDiagram(processInstanceId);
        byte[] media = IOUtils.toByteArray(in);
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.IMAGE_JPEG);
        return new ResponseEntity<>(media, headers, HttpStatus.OK);
    }

    @GetMapping("/diagram2")
    public void showDiagram2(String processInstanceId, HttpServletResponse response) throws IOException {

        InputStream in = activitiOptService.showDiagram(processInstanceId);
        response.setContentType(MediaType.IMAGE_JPEG_VALUE);
        IOUtils.copy(in, response.getOutputStream());

    }

    @PostMapping("/user/{userId}")
    public R<?> createUser(@PathVariable("userId") String userId, String userName) {

        Map<Object, Object> map = Maps.newHashMap();
        map.put("userId", activitiOptService.createUser(userId, userName));
        return R.ok(map);
    }

    @PostMapping("/group/{groupId}")
    public R<?> createUserGroup(@PathVariable("groupId") String groupId, String groupName, String userId) {

        Map<Object, Object> map = Maps.newHashMap();
        map.put("groupId", activitiOptService.createUserGroup(groupId, groupName, userId));
        return R.ok(map);
    }

    /**
     * 待办列表
     *
     * @param userId
     * @return
     */
    @GetMapping("/todo_list/{userId}")
    public R<?> todoList(@PathVariable("userId") String userId) {
        return R.ok(activitiOptService.todoList(userId));
    }

    /**
     * 待办列表
     *
     * @param userId
     * @return
     */
    @GetMapping("/todo_page_list/{userId}")
    public R<?> todoPageList(@PathVariable("userId") String userId, int pageNum, int pageSize) {
        return R.ok(activitiOptService.todoPageList(userId, pageNum, pageSize));
    }

    /**
     * 代办数量
     *
     * @param userId
     * @return
     */
    @GetMapping("/todo_list_count")
    public R<?> todoListCount(String userId) {
        return R.ok(activitiOptService.todoListCount(userId));
    }
    /**
     * 代办数量
     *
     * @param processInstanceId
     * @return
     */
    @GetMapping("/audit_hist_list")
    public R<?> auditHisList(String processInstanceId) {
        return R.ok(activitiOptService.auditHisList(processInstanceId));
    }

    /**
     *
     * @param taskId
     * @return
     */
    @GetMapping("/check_just_before")
    public R<?> checkJustBefore(String taskId) {
        return R.ok(activitiOptService.isFlowNodeJustBefore(taskId));
    }
    /**
     *
     * @param processInstanceId
     * @return
     */
    @GetMapping("/check_just_submit")
    public R<?> checkJustSubmit(String processInstanceId) {
        return R.ok(activitiOptService.isJustSubmit(processInstanceId));
    }


}
