package com.els.tso.workflow.model;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.*;

/**
 * 审批相关操作返回结果
 * @author wyssss
 * @since 2020-04-22
 */
@Getter
@Setter
public class AuditResult implements Serializable {
    private static final long serialVersionUID = 1L;
	/**
	 * 流程实例根id,每发起一个流程就会产生
	 */
	private String processRootId;
	/**
	 * 审批状态，操作完成后 返回审批状态(0, "审批通过", 1, "未审批", 2, "审批中", 3, "审批拒绝")
	 */
	private int auditStatus;
	/**
	 * 提交审批人elsAccount_elsSubAccount
	 */
	private String submitUser;

	/**
	 * 下一层级需要审批人列表，用于发送消息提醒 格式[elsAccount_elsSubAccount,elsAccount_elsSubAccount]
	 */
	private Set<String> nextAuditUserList = new HashSet<>();

    /**
     * 当前提交人(submitUser)的下一级任务id
     */
    private String nextTaskId;
    /**
     * taskMap返回适配器对应的taskId，用于发送消息提醒 格式{elsAccount_elsSubAccount:taskId,elsAccount_elsSubAccount:taskId}
     */
    private Map<String,Long> taskMap;

}
