/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.debug;

import com.enterprisedt.BaseIOException;
import com.enterprisedt.util.debug.Appender;
import com.enterprisedt.util.debug.Level;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Logger {
    public static String cvsId = "@(#)$Id: Logger.java,v 1.10 2006/05/22 01:53:03 hans Exp $";
    private static Level globalLevel;
    private SimpleDateFormat format = new SimpleDateFormat("d MMM yyyy HH:mm:ss.S");
    private static Hashtable loggers;
    private static Vector appenders;
    private boolean useLog4j = false;
    private Date ts = new Date();
    private String clazz;
    private Method[][] methods;
    private Object logger;
    private Object[] argsPlain = new Object[1];
    private Object[] argsThrowable = new Object[2];
    private static String[] hex;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;

    private Logger(String clazz, boolean uselog4j) {
        this.clazz = clazz;
        this.useLog4j = uselog4j;
        if (uselog4j) {
            this.setupLog4j();
        }
    }

    private void setupLog4j() {
        this.methods = new Method[5][2];
        try {
            Class<?> log4jLogger = Class.forName("org.apache.log4j.Logger");
            Class[] args = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Logger.class$("java.lang.String"))};
            Method getLogger = log4jLogger.getMethod("getLogger", args);
            Object[] invokeArgs = new Object[]{this.clazz};
            this.logger = getLogger.invoke(null, invokeArgs);
            Class[] plainArgs = new Class[]{class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Logger.class$("java.lang.Object"))};
            Class[] throwableArgs = new Class[]{class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Logger.class$("java.lang.Object")), class$java$lang$Throwable != null ? class$java$lang$Throwable : (class$java$lang$Throwable = Logger.class$("java.lang.Throwable"))};
            this.methods[0][0] = log4jLogger.getMethod("fatal", plainArgs);
            this.methods[0][1] = log4jLogger.getMethod("fatal", throwableArgs);
            this.methods[1][0] = log4jLogger.getMethod("error", plainArgs);
            this.methods[1][1] = log4jLogger.getMethod("error", throwableArgs);
            this.methods[2][0] = log4jLogger.getMethod("warn", plainArgs);
            this.methods[2][1] = log4jLogger.getMethod("warn", throwableArgs);
            this.methods[3][0] = log4jLogger.getMethod("info", plainArgs);
            this.methods[3][1] = log4jLogger.getMethod("info", throwableArgs);
            this.methods[4][0] = log4jLogger.getMethod("debug", plainArgs);
            this.methods[4][1] = log4jLogger.getMethod("debug", throwableArgs);
        }
        catch (Exception ex) {
            this.useLog4j = false;
            this.error("Failed to initialize log4j logging", ex);
        }
    }

    public static void setLevel(Level level) {
        globalLevel = level;
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String clazz) {
        Logger logger = (Logger)loggers.get(clazz);
        if (logger == null) {
            boolean useLog4j = false;
            try {
                String log4j = System.getProperty("edtftp.log.log4j");
                if (log4j != null && log4j.equalsIgnoreCase("true")) {
                    useLog4j = true;
                }
            }
            catch (SecurityException securityException) {
                System.out.println("Could not read property 'edtftp.log.log4j' due to security permissions");
            }
            logger = new Logger(clazz, useLog4j);
            loggers.put(clazz, logger);
        }
        return logger;
    }

    public static void addAppender(Appender newAppender) {
        appenders.addElement(newAppender);
    }

    public static void shutdown() {
        int i = 0;
        while (i < appenders.size()) {
            Appender a = (Appender)appenders.elementAt(i);
            a.close();
            ++i;
        }
    }

    public void log(Level level, String message, Throwable t) {
        if (this.useLog4j) {
            this.log4jLog(level, message, t);
        } else if (globalLevel.isGreaterOrEqual(level)) {
            this.ourLog(level, message, t);
        }
    }

    private void log4jLog(Level level, String message, Throwable t) {
        Object[] args = null;
        int pos = -1;
        if (t == null) {
            args = this.argsPlain;
            pos = 0;
        } else {
            args = this.argsThrowable;
            args[1] = t;
            pos = 1;
        }
        args[0] = message;
        Method method = this.methods[level.getLevel()][pos];
        try {
            method.invoke(this.logger, args);
        }
        catch (Exception ex) {
            this.ourLog(Level.ERROR, "Failed to invoke log4j method", ex);
            this.ourLog(level, message, t);
        }
    }

    private void ourLog(Level level, String message, Throwable t) {
        this.ts.setTime(System.currentTimeMillis());
        String stamp = this.format.format(this.ts);
        StringBuffer buf = new StringBuffer(level.toString());
        buf.append(" [").append(this.clazz).append("] ").append(stamp).append(" : ").append(message);
        if (t != null) {
            buf.append(" : ").append(t.getMessage());
        }
        if (appenders.size() == 0) {
            System.out.println(buf.toString());
            while (t != null) {
                t.printStackTrace(System.out);
                if (t instanceof BaseIOException) {
                    if ((t = ((BaseIOException)t).getInnerThrowable()) == null) continue;
                    System.out.println("CAUSED BY:");
                    continue;
                }
                t = null;
            }
        } else {
            int i = 0;
            while (i < appenders.size()) {
                Appender a = (Appender)appenders.elementAt(i);
                a.log(buf.toString());
                while (t != null) {
                    a.log(t);
                    if (t instanceof BaseIOException) {
                        if ((t = ((BaseIOException)t).getInnerThrowable()) == null) continue;
                        a.log("CAUSED BY:");
                        continue;
                    }
                    t = null;
                }
                ++i;
            }
        }
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void warn(String message) {
        this.log(Level.WARN, message, null);
    }

    public void warn(String message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void error(String message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void debug(String message, byte[] data) {
        this.log(Level.DEBUG, message, null);
        StringBuffer hexStr = new StringBuffer();
        StringBuffer charStr = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            byte b = data[i];
            if (i > 0 && i % 12 == 0) {
                this.log(Level.DEBUG, String.valueOf(hexStr.toString()) + "  " + charStr.toString(), null);
                hexStr = new StringBuffer();
                charStr = new StringBuffer();
            }
            hexStr.append(String.valueOf(hex[b >> 4 & 0xF]) + hex[b & 0xF] + " ");
            charStr.append(b >= 32 && b <= 126 ? (char)b : (char)'?');
            ++i;
        }
        this.log(Level.DEBUG, String.valueOf(hexStr.toString()) + "  " + charStr.toString(), null);
    }

    public void debug(String message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    public boolean isEnabledFor(Level level) {
        return globalLevel.isGreaterOrEqual(level);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(Level.INFO);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        loggers = new Hashtable(10);
        appenders = new Vector(2);
        String level = Level.OFF.toString();
        try {
            System.getProperty("edtftp.log.level", Level.OFF.toString());
        }
        catch (SecurityException securityException) {
            System.out.println("Could not read property 'edtftp.log.level' due to security permissions");
        }
        globalLevel = Level.getLevel(level);
        hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    }
}

