/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.ConnectionProperty;
import com.facebook.presto.jdbc.QueryInterceptor;
import com.facebook.presto.jdbc.internal.guava.base.CharMatcher;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.base.Splitter;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap;
import com.facebook.presto.jdbc.internal.okhttp3.Protocol;
import java.io.File;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;

abstract class AbstractConnectionProperty<T>
implements ConnectionProperty<T> {
    private final String key;
    private final Optional<String> defaultValue;
    private final Predicate<Properties> isRequired;
    private final Predicate<Properties> isAllowed;
    private final Converter<T> converter;
    protected static final Predicate<Properties> REQUIRED = properties -> true;
    protected static final Predicate<Properties> NOT_REQUIRED = properties -> false;
    protected static final Predicate<Properties> ALLOWED = properties -> true;
    protected static final Converter<String> STRING_CONVERTER = value -> value;
    protected static final Converter<String> NON_EMPTY_STRING_CONVERTER = value -> {
        Preconditions.checkArgument(!value.isEmpty(), "value is empty");
        return value;
    };
    protected static final Converter<File> FILE_CONVERTER = File::new;
    protected static final Converter<Boolean> BOOLEAN_CONVERTER = value -> {
        switch (value.toLowerCase(Locale.ENGLISH)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("value must be 'true' or 'false'");
    };

    protected AbstractConnectionProperty(String key, Optional<String> defaultValue, Predicate<Properties> isRequired, Predicate<Properties> isAllowed, Converter<T> converter) {
        this.key = Objects.requireNonNull(key, "key is null");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.isRequired = Objects.requireNonNull(isRequired, "isRequired is null");
        this.isAllowed = Objects.requireNonNull(isAllowed, "isAllowed is null");
        this.converter = Objects.requireNonNull(converter, "converter is null");
    }

    protected AbstractConnectionProperty(String key, Predicate<Properties> required, Predicate<Properties> allowed, Converter<T> converter) {
        this(key, Optional.empty(), required, allowed, converter);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Optional<String> getDefault() {
        return this.defaultValue;
    }

    @Override
    public DriverPropertyInfo getDriverPropertyInfo(Properties mergedProperties) {
        String currentValue = mergedProperties.getProperty(this.key);
        DriverPropertyInfo result = new DriverPropertyInfo(this.key, currentValue);
        result.required = this.isRequired.test(mergedProperties);
        return result;
    }

    @Override
    public boolean isRequired(Properties properties) {
        return this.isRequired.test(properties);
    }

    @Override
    public boolean isAllowed(Properties properties) {
        return !properties.containsKey(this.key) || this.isAllowed.test(properties);
    }

    @Override
    public Optional<T> getValue(Properties properties) throws SQLException {
        String value = properties.getProperty(this.key);
        if (value == null) {
            if (this.isRequired(properties)) {
                throw new SQLException(String.format("Connection property '%s' is required", this.key));
            }
            return Optional.empty();
        }
        try {
            return Optional.of(this.converter.convert(value));
        }
        catch (RuntimeException e) {
            if (value.isEmpty()) {
                throw new SQLException(String.format("Connection property '%s' value is empty", this.key), e);
            }
            throw new SQLException(String.format("Connection property '%s' value is invalid: %s", this.key, value), e);
        }
    }

    @Override
    public void validate(Properties properties) throws SQLException {
        if (!this.isAllowed(properties)) {
            throw new SQLException(String.format("Connection property '%s' is not allowed", this.key));
        }
        this.getValue(properties);
    }

    protected static <T> Predicate<T> checkedPredicate(CheckedPredicate<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (SQLException e) {
                return false;
            }
        };
    }

    protected static interface CheckedPredicate<T> {
        public boolean test(T var1) throws SQLException;
    }

    protected static final class HttpProtocolConverter
    implements Converter<List<Protocol>> {
        public static final HttpProtocolConverter HTTP_PROTOCOL_CONVERTER = new HttpProtocolConverter();

        private HttpProtocolConverter() {
        }

        @Override
        public List<Protocol> convert(String value) {
            return Splitter.on(',').splitToList(value).stream().map(this::loadProtocol).distinct().collect(ImmutableList.toImmutableList());
        }

        private Protocol loadProtocol(String protocolName) {
            try {
                switch (protocolName.toLowerCase(Locale.ENGLISH)) {
                    case "http11": {
                        return Protocol.HTTP_1_1;
                    }
                    case "http10": {
                        return Protocol.HTTP_1_0;
                    }
                    case "http2": {
                        return Protocol.HTTP_2;
                    }
                }
                return Protocol.get(protocolName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Could not load OkhttpProtocol from %s", protocolName), e);
            }
        }
    }

    protected static final class ClassListConverter
    implements Converter<List<QueryInterceptor>> {
        public static final ClassListConverter CLASS_LIST_CONVERTER = new ClassListConverter();

        private ClassListConverter() {
        }

        @Override
        public List<QueryInterceptor> convert(String value) {
            return Splitter.on(';').splitToList(value).stream().map(this::loadClass).collect(ImmutableList.toImmutableList());
        }

        private QueryInterceptor loadClass(String interceptor) {
            try {
                return (QueryInterceptor)Class.forName(interceptor).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(String.format("Could not load QueryInterceptor classes from %s", interceptor), e);
            }
        }
    }

    protected static final class StringMapConverter
    implements Converter<Map<String, String>> {
        private static final CharMatcher PRINTABLE_ASCII = CharMatcher.inRange('!', '~');
        public static final StringMapConverter STRING_MAP_CONVERTER = new StringMapConverter();

        private StringMapConverter() {
        }

        @Override
        public Map<String, String> convert(String value) {
            return Splitter.on(';').splitToList(value).stream().map(this::parseKeyValuePair).collect(ImmutableMap.toImmutableMap(entry -> (String)entry.get(0), entry -> (String)entry.get(1)));
        }

        public List<String> parseKeyValuePair(String keyValue) {
            List<String> nameValue = Splitter.on(':').splitToList(keyValue);
            Preconditions.checkArgument(nameValue.size() == 2, "Malformed key value pair: %s", (Object)keyValue);
            String name = nameValue.get(0);
            String value = nameValue.get(1);
            Preconditions.checkArgument(!name.isEmpty(), "Key is empty");
            Preconditions.checkArgument(!value.isEmpty(), "Value is empty");
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(name), "Key contains spaces or is not printable ASCII: %s", (Object)name);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(value), "Value contains spaces or is not printable ASCII: %s", (Object)name);
            return nameValue;
        }
    }

    static interface Converter<T> {
        public T convert(String var1);
    }
}

