/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.common.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.common.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.common.block.VariableWidthBlock;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slices;

public class VariableWidthBlockEncoding
implements BlockEncoding {
    public static final String NAME = "VARIABLE_WIDTH";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        AbstractVariableWidthBlock variableWidthBlock = (AbstractVariableWidthBlock)block;
        int positionCount = variableWidthBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        int totalLength = 0;
        for (int position = 0; position < positionCount; ++position) {
            int length = variableWidthBlock.getSliceLength(position);
            sliceOutput.appendInt(totalLength += length);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, variableWidthBlock);
        sliceOutput.appendInt(totalLength).writeBytes(variableWidthBlock.getRawSlice(0), variableWidthBlock.getPositionOffset(0), totalLength);
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        sliceInput.readBytes(Slices.wrappedIntArray(offsets), 4, positionCount * 4);
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        int blockSize = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(blockSize);
        return new VariableWidthBlock(0, positionCount, slice, offsets, valueIsNull);
    }
}

