/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.function.WindowFunction;
import com.facebook.presto.jdbc.internal.spi.function.WindowIndex;

public abstract class RankingWindowFunction
implements WindowFunction {
    protected WindowIndex windowIndex;
    private int currentPeerGroupStart;
    private int currentPosition;

    @Override
    public final void reset(WindowIndex windowIndex) {
        this.windowIndex = windowIndex;
        this.currentPeerGroupStart = -1;
        this.currentPosition = 0;
        this.reset();
    }

    @Override
    public final void processRow(BlockBuilder output, int peerGroupStart, int peerGroupEnd, int frameStart, int frameEnd) {
        boolean newPeerGroup = false;
        if (peerGroupStart != this.currentPeerGroupStart) {
            this.currentPeerGroupStart = peerGroupStart;
            newPeerGroup = true;
        }
        int peerGroupCount = peerGroupEnd - peerGroupStart + 1;
        this.processRow(output, newPeerGroup, peerGroupCount, this.currentPosition);
        ++this.currentPosition;
    }

    public void reset() {
    }

    public abstract void processRow(BlockBuilder var1, boolean var2, int var3, int var4);
}

