/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.predicate.TupleDomain;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.TableHandle;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public final class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final List<VariableReferenceExpression> outputVariables;
    private final TupleDomain<ColumnHandle> currentConstraint;
    private final TupleDomain<ColumnHandle> enforcedConstraint;

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="assignments") Map<VariableReferenceExpression, ColumnHandle> assignments) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        TableScanNode.checkArgument(assignments.keySet().containsAll(outputVariables), "assignments does not cover all of outputs");
        this.currentConstraint = null;
        this.enforcedConstraint = null;
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        TableScanNode.checkArgument(assignments.keySet().containsAll(outputVariables), "assignments does not cover all of outputs");
        this.currentConstraint = Objects.requireNonNull(currentConstraint, "currentConstraint is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        if (!currentConstraint.isAll() || !enforcedConstraint.isAll()) {
            TableScanNode.checkArgument(table.getLayout().isPresent(), "tableLayout must be present when currentConstraint or enforcedConstraint is non-trivial");
        }
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @Nullable
    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        return this.currentConstraint;
    }

    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        TableScanNode.checkState(this.enforcedConstraint != null, "enforcedConstraint should only be used in planner. It is not transported to workers.");
        return this.enforcedConstraint;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append("table='").append(this.table).append('\'');
        stringBuilder.append(", outputVariables='").append(this.outputVariables).append('\'');
        stringBuilder.append(", assignments='").append(this.assignments).append('\'');
        stringBuilder.append(", currentConstraint='").append(this.currentConstraint).append('\'');
        stringBuilder.append(", enforcedConstraint='").append(this.enforcedConstraint).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        TableScanNode.checkArgument(newChildren.isEmpty(), "newChildren is not empty");
        return this;
    }

    private static void checkArgument(boolean test, String errorMessage) {
        if (!test) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void checkState(boolean test, String errorMessage) {
        if (!test) {
            throw new IllegalStateException(errorMessage);
        }
    }
}

