/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.utils.crypt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fadada.sdk.utils.crypt.FddEncryptTool;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class MsgDigestUtil {
    public static String[] sortforParameters(Map<String, String> parameters) {
        String[] codes = new String[parameters.size()];
        TreeMap<String, String> paramMap = new TreeMap<String, String>(parameters);
        int index = 0;
        for (Object key : paramMap.keySet()) {
            Object value = paramMap.get(key);
            if (value instanceof JSONObject) {
                codes[index] = JSON.toJSONString(value);
                ++index;
                continue;
            }
            if (!(value instanceof String)) continue;
            codes[index] = (String)value;
            ++index;
        }
        return codes;
    }

    public static String sortString(Map<String, String> parameters) {
        String[] strings = MsgDigestUtil.sortforParameters(parameters);
        StringBuilder sb = new StringBuilder();
        for (String str : strings) {
            if (!StringUtils.isNotBlank(str)) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    public static String getMsgDigest(String str, String timestamp, String appId, String secret) {
        String sha1 = "";
        try {
            sha1 = FddEncryptTool.sha1(appId + FddEncryptTool.md5Digest(timestamp) + FddEncryptTool.sha1(secret + str));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new String(FddEncryptTool.Base64Encode(sha1.getBytes()));
    }
}

