/*
 * Decompiled with CFR 0.152.
 */
package com.fit2cloud.quartz;

import com.fit2cloud.quartz.anno.QuartzScheduled;
import com.fit2cloud.quartz.config.ClusterQuartzFixedDelayJobBean;
import com.fit2cloud.quartz.config.ClusterQuartzJobBean;
import com.fit2cloud.quartz.config.FixedDelayJobData;
import com.fit2cloud.quartz.config.FixedDelayJobListener;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SchedulerStarter
implements BeanPostProcessor,
ApplicationContextAware {
    private Instant now;
    @Resource
    private Scheduler scheduler;
    @Resource
    private TimeZone quartzTimeZone;
    private Map<String, JobDetailTrigger> jobDetailTriggerMap = new HashMap<String, JobDetailTrigger>();
    private ConfigurableApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass());
        if (methods != null) {
            for (Method method : methods) {
                Trigger trigger;
                JobDetail jobDetail;
                QuartzScheduled annotation = (QuartzScheduled)AnnotationUtils.findAnnotation((Method)method, QuartzScheduled.class);
                if (annotation == null) continue;
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("targetObject", beanName);
                jobDataMap.put("targetMethod", method.getName());
                String cron = annotation.cron();
                long fixedDelay = annotation.fixedDelay();
                long fixedRate = annotation.fixedRate();
                int initialDelay = (int)annotation.initialDelay();
                String jobDetailIdentity = beanName + "." + method.getName();
                if (!StringUtils.isEmpty((Object)cron)) {
                    cron = this.getCronExpression(cron);
                    jobDetail = JobBuilder.newJob(ClusterQuartzJobBean.class).storeDurably(true).usingJobData(jobDataMap).build();
                    trigger = TriggerBuilder.newTrigger().withIdentity(jobDetailIdentity).startAt(new Date(this.now.plusMillis(initialDelay).toEpochMilli())).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron).inTimeZone(this.quartzTimeZone)).build();
                } else if (fixedDelay > 0L) {
                    jobDataMap.put("FIXED_DELAY_JOB_DATA", (Object)new FixedDelayJobData(fixedDelay));
                    jobDetail = JobBuilder.newJob(ClusterQuartzFixedDelayJobBean.class).storeDurably(true).usingJobData(jobDataMap).build();
                    trigger = TriggerBuilder.newTrigger().withIdentity(jobDetailIdentity).startAt(new Date(this.now.plusMillis(initialDelay).toEpochMilli())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(fixedDelay).repeatForever()).build();
                } else {
                    jobDetail = JobBuilder.newJob(ClusterQuartzJobBean.class).storeDurably(true).usingJobData(jobDataMap).build();
                    trigger = TriggerBuilder.newTrigger().withIdentity(jobDetailIdentity).startAt(new Date(this.now.plusMillis(initialDelay).toEpochMilli())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(fixedRate).repeatForever()).build();
                }
                this.jobDetailTriggerMap.put(jobDetailIdentity, new JobDetailTrigger(jobDetail, trigger));
            }
        }
        return bean;
    }

    private String getCronExpression(String cron) {
        if ((cron = cron.trim()).startsWith("${") && cron.endsWith("}")) {
            return this.applicationContext.getBeanFactory().resolveEmbeddedValue(cron);
        }
        return cron;
    }

    @EventListener
    public void startScheduler(ContextRefreshedEvent event) throws BeansException {
        try {
            this.scheduler.deleteJobs(this.getJobKeys());
            this.scheduler.unscheduleJobs(this.getTriggerKeys());
            this.scheduler.getListenerManager().addJobListener((JobListener)new FixedDelayJobListener());
            for (String jobDetailIdentity : this.jobDetailTriggerMap.keySet()) {
                JobDetailTrigger jobDetailTrigger = this.jobDetailTriggerMap.get(jobDetailIdentity);
                this.scheduler.scheduleJob(jobDetailTrigger.jobDetail, jobDetailTrigger.trigger);
            }
            if (!this.scheduler.isShutdown()) {
                this.scheduler.startDelayed(60);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    private List<JobKey> getJobKeys() throws SchedulerException {
        List jobGroupNames = this.scheduler.getJobGroupNames();
        ArrayList<JobKey> jobKeys = new ArrayList<JobKey>();
        for (String jobGroupName : jobGroupNames) {
            jobKeys.addAll(this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)jobGroupName)));
        }
        return jobKeys;
    }

    private List<TriggerKey> getTriggerKeys() throws SchedulerException {
        List triggerGroupNames = this.scheduler.getJobGroupNames();
        ArrayList<TriggerKey> triggerKeys = new ArrayList<TriggerKey>();
        for (String triggerGroupName : triggerGroupNames) {
            triggerKeys.addAll(this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)triggerGroupName)));
        }
        return triggerKeys;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.now = Instant.now();
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    private static class JobDetailTrigger {
        JobDetail jobDetail;
        Trigger trigger;

        JobDetailTrigger(JobDetail jobDetail, Trigger trigger) {
            this.jobDetail = jobDetail;
            this.trigger = trigger;
        }
    }
}

