/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.wsdl.BindingOperation;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Message;
import com.sforce.ws.wsdl.Part;
import com.sforce.ws.wsdl.SoapHeader;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class Binding
extends WsdlNode {
    private Definitions definitions;
    private HashMap<QName, BindingOperation> operations = new HashMap();
    private String name;

    public Binding(Definitions definitions) {
        this.definitions = definitions;
    }

    public String getName() {
        return this.name;
    }

    public Iterator<Part> getAllHeaders() throws ConnectionException {
        HashSet<Part> headers = new HashSet<Part>();
        for (BindingOperation operation : this.operations.values()) {
            this.addHeaders(operation.getInput().getHeaders(), headers);
            this.addHeaders(operation.getOutput().getHeaders(), headers);
        }
        return headers.iterator();
    }

    private void addHeaders(Iterator<SoapHeader> hs, HashSet<Part> headers) throws ConnectionException {
        while (hs.hasNext()) {
            SoapHeader h = hs.next();
            Message message = this.definitions.getMessage(h.getMessage());
            Part part = message.getPart(h.getPart());
            if (headers.contains(part)) continue;
            headers.add(part);
        }
    }

    public BindingOperation getOperation(QName name) throws ConnectionException {
        BindingOperation op = this.operations.get(name);
        if (op == null) {
            throw new ConnectionException("Unable to find binding operation for " + name);
        }
        return op;
    }

    void read(WsdlParser parser) throws WsdlParseException {
        this.name = parser.getAttributeValue(null, "name");
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if (name != null && namespace != null) {
                    this.parse(name, namespace, parser);
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("binding".equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    private void parse(String name, String namespace, WsdlParser parser) throws WsdlParseException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
            if ("operation".equals(name)) {
                BindingOperation operation = new BindingOperation(this.definitions);
                operation.read(parser);
                this.operations.put(operation.getQName(), operation);
            }
        } else if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(namespace) && "binding".equals(name)) {
            String style = parser.getAttributeValue(null, "style");
            String transport = parser.getAttributeValue(null, "transport");
            if (style != null && !"document".equals(style)) {
                throw new WsdlParseException("Unsupported WSDL style '" + style + "'. Only supports Dcoument/literal/wrapped services. " + parser.getPositionDescription());
            }
            if (transport != null && !"http://schemas.xmlsoap.org/soap/http".equals(transport)) {
                throw new WsdlParseException("Unsupported transport " + transport + " " + parser.getPositionDescription());
            }
        }
    }
}

