/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.http;

import com.fujieid.jap.http.JapHttpCookie;
import com.fujieid.jap.http.JapHttpRequest;
import com.fujieid.jap.http.JapHttpResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestUtil {
    public static String getParam(String paramName, JapHttpRequest request) {
        if (null == request) {
            return null;
        }
        return request.getParameter(paramName);
    }

    public static String getHeader(String headerName, JapHttpRequest request) {
        if (null == request) {
            return "";
        }
        return request.getHeader(headerName);
    }

    public static String getReferer(JapHttpRequest request) {
        return RequestUtil.getHeader("Referer", request);
    }

    public static String getFullDomainName(JapHttpRequest request) {
        StringBuffer url = request.getRequestUrl();
        return url.delete(url.length() - request.getRequestUri().length(), url.length()).toString();
    }

    public static String getUa(JapHttpRequest request) {
        return RequestUtil.getHeader("User-Agent", request);
    }

    public static String getIp(JapHttpRequest request) {
        String ip;
        String[] headers;
        if (null == request) {
            return "";
        }
        for (String header : headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"}) {
            ip = request.getHeader(header);
            if (!RequestUtil.isValidIp(ip)) continue;
            return RequestUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return RequestUtil.getMultistageReverseProxyIp(ip);
    }

    private static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (!RequestUtil.isValidIp(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    private static boolean isValidIp(String ip) {
        return RequestUtil.isNotEmpty(ip) && !"unknown".equalsIgnoreCase(ip);
    }

    public static String getCookieVal(JapHttpRequest request, String name) {
        JapHttpCookie cookie = RequestUtil.getCookie(request, name);
        return cookie != null ? cookie.getValue() : null;
    }

    private static boolean isNotEmpty(String s) {
        return s != null && s.trim().length() != 0;
    }

    public static String getRequestUrl(boolean encode, JapHttpRequest request) {
        if (null == request) {
            return "";
        }
        String currentUrl = request.getRequestUrl().toString();
        String queryString = request.getQueryString();
        if (RequestUtil.isNotEmpty(queryString)) {
            currentUrl = currentUrl + "?" + queryString;
        }
        if (encode) {
            String result = "";
            try {
                result = URLEncoder.encode(currentUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return result;
        }
        return currentUrl;
    }

    public static JapHttpCookie getCookie(JapHttpRequest request, String name) {
        JapHttpCookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (JapHttpCookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Map<String, JapHttpCookie> getCookieMap(JapHttpRequest request) {
        JapHttpCookie[] cookies = request.getCookies();
        if (null == cookies || cookies.length == 0) {
            return new HashMap<String, JapHttpCookie>(0);
        }
        return Arrays.stream(cookies).collect(Collectors.toMap(JapHttpCookie::getName, v -> v, (k1, k2) -> k1));
    }

    public static void setCookie(JapHttpResponse response, String name, String value, int maxAge, String path, String domain) {
        JapHttpCookie cookie = new JapHttpCookie(name, value);
        cookie.setPath(path);
        if (null != domain) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAge);
        cookie.setHttpOnly(false);
        response.addCookie(cookie);
    }
}

