/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.common.permission;

import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.permission.ApiPermissionClient;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component(value="apiPermissionAspect")
public class ApiPermissionAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiPermissionAspect.class);
    @Resource
    private ApiPermissionClient permissionClient;

    @Before(value="@annotation(apiPermission) || @within(apiPermission)")
    public void doBefore(JoinPoint joinPoint, ApiPermission apiPermission) {
        String[] permissions;
        boolean verify;
        boolean required;
        if (!this.permissionClient.hasPermissionService()) {
            return;
        }
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        Class<?> targetClass = joinPoint.getTarget().getClass();
        ApiPermission classAnnotation = targetClass.getAnnotation(ApiPermission.class);
        boolean classRequired = classAnnotation != null && classAnnotation.required();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ApiPermission methodAnnotation = method.getAnnotation(ApiPermission.class);
        boolean methodRequired = methodAnnotation != null && methodAnnotation.required();
        boolean bl = required = methodRequired || classRequired;
        if (required && !(verify = this.permissionClient.verifyApiPermission(request, permissions = methodAnnotation != null ? methodAnnotation.permissions() : classAnnotation.permissions()))) {
            throw new GlobalException("\u6743\u9650\u4e0d\u8db3");
        }
    }

    @AfterThrowing(pointcut="@annotation(apiPermission) || @within(apiPermission)")
    public void doAfterThrowing(JoinPoint joinPoint, ApiPermission apiPermission) {
    }
}

