/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.common.utils;

import com.gccloud.common.exception.GlobalException;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.transform.TimedInterrupt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.kohsuke.groovy.sandbox.SandboxTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyUtils {
    private static final Logger log = LoggerFactory.getLogger(GroovyUtils.class);
    static final Cache<String, Class> CACHE_CLASS = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public static Object run(String groovyScript, Map<String, Object> params) {
        Class clazz = GroovyUtils.buildClass(groovyScript);
        if (clazz == null) {
            return null;
        }
        Binding binding = new Binding();
        Map variables = binding.getVariables();
        if (params != null) {
            variables.putAll(params);
        }
        try {
            Script script = InvokerHelper.createScript((Class)clazz, (Binding)binding);
            Object result = script.run();
            return result;
        }
        catch (Exception e) {
            CACHE_CLASS.invalidate((Object)groovyScript);
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GlobalException("\u811a\u672c\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    public static Class buildClass(String groovyScript) {
        if (StringUtils.isBlank((CharSequence)groovyScript)) {
            return null;
        }
        Class clazz = (Class)CACHE_CLASS.get((Object)groovyScript, script -> {
            try {
                return GroovyUtils.buildClassSafe(script);
            }
            catch (Exception e) {
                log.error("\u811a\u672c {} \u7f16\u8bd1\u5931\u8d25:{}", script, (Object)e);
                return null;
            }
        });
        return clazz;
    }

    public static Class<?> buildClassSafe(String groovyScript) {
        CompilerConfiguration config = new CompilerConfiguration();
        SecureASTCustomizer secure = new SecureASTCustomizer();
        secure.setClosuresAllowed(true);
        ArrayList<Integer> tokensBlacklist = new ArrayList<Integer>();
        tokensBlacklist.add(571);
        tokensBlacklist.add(701);
        secure.setTokensBlacklist(tokensBlacklist);
        config.addCompilationCustomizers(new CompilationCustomizer[]{secure});
        ArrayList<Class<WhileStatement>> statementBlacklist = new ArrayList<Class<WhileStatement>>();
        statementBlacklist.add(WhileStatement.class);
        secure.setStatementsBlacklist(statementBlacklist);
        HashMap<String, Integer> timeoutArgs = new HashMap<String, Integer>();
        timeoutArgs.put("value", 3);
        config.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(timeoutArgs, TimedInterrupt.class)});
        config.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
        List interceptors = GroovyInterceptor.getApplicableInterceptors();
        HashMap<Class, Supplier> interceptorMap = new HashMap<Class, Supplier>();
        interceptorMap.put(GroovyNotSupportInterceptor.class, GroovyNotSupportInterceptor::new);
        interceptorMap.forEach((clazz, supplier) -> {
            boolean hasInterceptor = interceptors.stream().anyMatch(interceptor -> interceptor.getClass().equals(clazz));
            if (!hasInterceptor) {
                ((GroovyInterceptor)supplier.get()).register();
            }
        });
        ClassLoader parent = GroovyUtils.class.getClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(parent, config);
        Class groovyClass = loader.parseClass(groovyScript);
        try {
            loader.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return groovyClass;
    }

    static class GroovyNotSupportInterceptor
    extends GroovyInterceptor {
        private final List<String> defaultMethodBlacklist = Arrays.asList("getClass", "class", "wait", "notify", "notifyAll", "invokeMethod", "finalize", "execute");
        private final List<Class> defaultClassBlacklist = Arrays.asList(File.class, FileInputStream.class, FileOutputStream.class, FileReader.class, FileWriter.class, RandomAccessFile.class, BufferedReader.class, BufferedWriter.class, URL.class, Files.class);

        GroovyNotSupportInterceptor() {
        }

        public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
            if (receiver == System.class && "exit".equals(method)) {
                throw new GlobalException("\u7531\u4e8e\u5b89\u5168\u9650\u5236\uff0c\u7981\u6b62\u4f7f\u7528\u65b9\u6cd5: System.exit()");
            }
            if (receiver == Runtime.class) {
                throw new GlobalException("\u7531\u4e8e\u5b89\u5168\u9650\u5236\uff0c\u7981\u6b62\u4f7f\u7528\u65b9\u6cd5: Runtime.getRuntime().exec()");
            }
            if (receiver == Class.class && "forName".equals(method)) {
                throw new GlobalException("\u7531\u4e8e\u5b89\u5168\u9650\u5236\uff0c\u7981\u6b62\u4f7f\u7528\u65b9\u6cd5: Class.forName()");
            }
            return super.onStaticCall(invoker, receiver, method, args);
        }

        public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
            if (this.defaultClassBlacklist.contains(receiver.getClass())) {
                throw new GlobalException("\u7531\u4e8e\u5b89\u5168\u9650\u5236\uff0c\u7981\u6b62\u4f7f\u7528\u7c7b: " + receiver.getClass().getName());
            }
            if (this.defaultMethodBlacklist.contains(method)) {
                throw new GlobalException("\u7531\u4e8e\u5b89\u5168\u9650\u5236\uff0c\u7981\u6b62\u4f7f\u7528\u65b9\u6cd5: " + method);
            }
            return super.onMethodCall(invoker, receiver, method, args);
        }

        public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
            if (this.defaultClassBlacklist.contains(receiver)) {
                throw new GlobalException("\u7531\u4e8e\u5b89\u5168\u9650\u5236\uff0c\u7981\u6b62\u4f7f\u7528\u7c7b: " + receiver.getName());
            }
            if (receiver.getName().startsWith("java.nio.file")) {
                throw new GlobalException("\u7531\u4e8e\u5b89\u5168\u9650\u5236\uff0c\u7981\u6b62\u4f7f\u7528\u7c7b: " + receiver.getName());
            }
            return super.onNewInstance(invoker, receiver, args);
        }
    }
}

