/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.common.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSON {
    private static final Logger log = LoggerFactory.getLogger(JSON.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JSON() {
    }

    public static ObjectMapper getInstance() {
        return OBJECT_MAPPER;
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        return (T)OBJECT_MAPPER.readValue(text, clazz);
    }

    public static <T> T parseObject(JSONObject jsonObject, Class<T> clazz) {
        return (T)OBJECT_MAPPER.readValue(jsonObject.toString(), clazz);
    }

    public static <T> T parseObject(String text, Type type) {
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructType(type);
        return (T)OBJECT_MAPPER.readValue(text, javaType);
    }

    public static JSONObject parseObject(String text) {
        return (JSONObject)OBJECT_MAPPER.readValue(text, JSONObject.class);
    }

    public static JSONArray parseArray(String text) {
        return (JSONArray)OBJECT_MAPPER.readValue(text, JSONArray.class);
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        CollectionType listType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
        return (List)OBJECT_MAPPER.readValue(text, (JavaType)listType);
    }

    public static String toJSONString(Object object) {
        return OBJECT_MAPPER.writeValueAsString(object);
    }

    static {
        OBJECT_MAPPER.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        OBJECT_MAPPER.registerModule((Module)new JsonOrgModule());
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setLocale(Locale.CHINA);
    }
}

