/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.controller;

import com.gccloud.common.permission.ApiPermission;
import com.gccloud.common.vo.R;
import com.gccloud.dataset.dto.CategorySearchDTO;
import com.gccloud.dataset.entity.CategoryEntity;
import com.gccloud.dataset.service.ICategoryService;
import com.gccloud.dataset.vo.CategoryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u96c6"})
@RestController
@RequestMapping(value={"/category"})
@ConditionalOnProperty(prefix="gc.starter.dataset.component", name={"DatasetCategoryController"}, havingValue="DatasetCategoryController", matchIfMissing=true)
public class CategoryController {
    @Resource
    private ICategoryService categoryService;

    @ApiOperation(value="\u4f9d\u636e\u7c7b\u578b\u67e5\u8be2\u5bf9\u5e94\u7684\u79cd\u7c7b\u6811")
    @GetMapping(value={"/queryTreeList"})
    @ApiPermission(permissions={"dataset:category"})
    public R<List<CategoryVO>> queryTreeList(CategorySearchDTO searchDTO) {
        List<CategoryVO> tree = this.categoryService.getTree(searchDTO);
        return R.success(tree);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/add"})
    @ApiPermission(permissions={"dataset:category:edit"})
    public R<String> add(@RequestBody CategoryEntity categoryEntity) {
        String id = this.categoryService.add(categoryEntity);
        return R.success((Object)id);
    }

    @ApiOperation(value="\u4fee\u6539")
    @PostMapping(value={"/update"})
    @ApiPermission(permissions={"dataset:category:edit"})
    public R<Void> update(@RequestBody CategoryEntity categoryEntity) {
        this.categoryService.update(categoryEntity);
        return R.success();
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete/{id}"})
    @ApiPermission(permissions={"dataset:category:edit"})
    public R<Void> delete(@PathVariable String id) {
        this.categoryService.delete(id);
        return R.success();
    }

    @ApiOperation(value="\u540d\u79f0\u67e5\u91cd")
    @PostMapping(value={"/checkRepeat"})
    @ApiPermission(permissions={"dataset:category"})
    public R<Boolean> checkRepeat(@RequestBody CategoryEntity entity) {
        Boolean flag = this.categoryService.checkNameRepeat(entity);
        return R.success((Object)flag);
    }
}

