/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.factory;

import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.service.IBaseDataSetService;
import com.gccloud.dataset.service.impl.dataset.BaseDatasetServiceImpl;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class DataSetServiceFactory {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private BaseDatasetServiceImpl baseDatasetService;

    public IBaseDataSetService build(String type) {
        return (IBaseDataSetService)this.applicationContext.getBean(type, IBaseDataSetService.class);
    }

    public IBaseDataSetService buildById(String id) {
        DatasetEntity dataset = this.baseDatasetService.getByIdFromCache(id);
        String datasetType = dataset.getDatasetType();
        return (IBaseDataSetService)this.applicationContext.getBean(datasetType, IBaseDataSetService.class);
    }
}

