/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.apache;

import java.io.IOException;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApacheSimplePostRequestExecutor
extends SimplePostRequestExecutor<CloseableHttpClient, HttpHost> {
    public ApacheSimplePostRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    /*
     * Loose catch block
     */
    @Override
    public String execute(String uri, String postEntity, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (postEntity != null) {
            StringEntity entity = new StringEntity(postEntity, Consts.UTF_8);
            entity.setContentType("application/json; charset=utf-8");
            httpPost.setEntity((HttpEntity)entity);
        }
        try {
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost);){
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                String string = this.handleResponse(wxType, responseContent);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }
}

