/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.bean.WxCpTpDepart;
import me.chanjar.weixin.cp.tp.service.WxCpTpDepartmentService;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpTpDepartmentServiceImpl
implements WxCpTpDepartmentService {
    private final WxCpTpService mainService;

    @Override
    public Long create(WxCpTpDepart depart) throws WxErrorException {
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/department/create");
        String responseContent = this.mainService.post(url, depart.toJson());
        JsonObject tmpJsonObject = GsonParser.parse((String)responseContent);
        return GsonHelper.getAsLong((JsonElement)tmpJsonObject.get("id"));
    }

    @Override
    public void update(WxCpTpDepart group) throws WxErrorException {
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/department/update");
        this.mainService.post(url, group.toJson());
    }

    @Override
    public void delete(Long departId) throws WxErrorException {
        String url = String.format(this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/department/delete?id=%d"), departId);
        this.mainService.get(url, null);
    }

    @Override
    public List<WxCpTpDepart> list(Long id, String corpId) throws WxErrorException {
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/department/list");
        url = url + "?access_token=" + this.mainService.getWxCpTpConfigStorage().getAccessToken(corpId);
        if (id != null) {
            url = url + "&id=" + id;
        }
        String responseContent = this.mainService.get(url, null);
        JsonObject tmpJsonObject = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJsonObject.get("department"), new TypeToken<List<WxCpTpDepart>>(){}.getType());
    }

    @Override
    public List<WxCpTpDepart> list(String corpId) throws WxErrorException {
        return this.list(null, corpId);
    }

    public WxCpTpDepartmentServiceImpl(WxCpTpService mainService) {
        this.mainService = mainService;
    }
}

