/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.cp.bean.article.MpnewsArticle;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import org.apache.commons.lang3.ArrayUtils;

public class WxCpSchoolContactMessage
implements Serializable {
    private static final long serialVersionUID = 8833792280163704238L;
    @SerializedName(value="recv_scope")
    private Integer recvScope = 0;
    @SerializedName(value="to_parent_userid")
    private String[] toParentUserId;
    @SerializedName(value="to_student_userid")
    private String[] toStudentUserId;
    @SerializedName(value="to_party")
    private String[] toParty;
    @SerializedName(value="toall")
    private Boolean toAll = false;
    @SerializedName(value="msgtype")
    private String msgType;
    @SerializedName(value="agentid")
    private Integer agentId;
    @SerializedName(value="content")
    private String content;
    @SerializedName(value="enable_id_trans")
    private Boolean enableIdTrans = false;
    @SerializedName(value="enable_duplicate_check")
    private Boolean enableDuplicateCheck = false;
    @SerializedName(value="duplicate_check_interval")
    private Integer duplicateCheckInterval;
    @SerializedName(value="media_id")
    private String mediaId;
    @SerializedName(value="title")
    private String title;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="thumb_media_id")
    private String thumbMediaId;
    @SerializedName(value="appid")
    private String appId;
    @SerializedName(value="pagepath")
    private String pagePath;
    private List<NewArticle> articles = new ArrayList<NewArticle>();
    private List<MpnewsArticle> mpNewsArticles = new ArrayList<MpnewsArticle>();

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String toJson() {
        JsonObject messageJson = new JsonObject();
        if (this.getRecvScope() != null) {
            messageJson.addProperty("recv_scope", (Number)this.getRecvScope());
        }
        if (ArrayUtils.isNotEmpty((Object[])this.getToParentUserId())) {
            messageJson.add("to_parent_userid", WxGsonBuilder.create().toJsonTree((Object)this.getToParentUserId()));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.getToStudentUserId())) {
            messageJson.add("to_student_userid", WxGsonBuilder.create().toJsonTree((Object)this.getToStudentUserId()));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.getToParty())) {
            messageJson.add("to_party", WxGsonBuilder.create().toJsonTree((Object)this.getToParty()));
        }
        if (this.getToAll() != null) {
            messageJson.addProperty("toall", (Number)(this.getToAll() != false ? 1 : 0));
        }
        messageJson.addProperty("msgtype", this.getMsgType());
        if (this.getAgentId() != null) {
            messageJson.addProperty("agentid", (Number)this.getAgentId());
        }
        if (this.getEnableIdTrans() != null && this.getEnableIdTrans().booleanValue()) {
            messageJson.addProperty("enable_id_trans", (Number)1);
        }
        if (this.getEnableDuplicateCheck() != null && this.getEnableDuplicateCheck().booleanValue()) {
            messageJson.addProperty("enable_duplicate_check", (Number)1);
        }
        if (this.getDuplicateCheckInterval() != null) {
            messageJson.addProperty("duplicate_check_interval", (Number)this.getDuplicateCheckInterval());
        }
        this.handleMsgType(messageJson);
        return messageJson.toString();
    }

    private void handleMsgType(JsonObject messageJson) {
        switch (this.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("image", (JsonElement)image);
                break;
            }
            case "file": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("file", (JsonElement)image);
                break;
            }
            case "voice": {
                JsonObject voice = new JsonObject();
                voice.addProperty("media_id", this.getMediaId());
                messageJson.add("voice", (JsonElement)voice);
                break;
            }
            case "video": {
                JsonObject video = new JsonObject();
                video.addProperty("media_id", this.getMediaId());
                video.addProperty("title", this.getTitle());
                video.addProperty("description", this.getDescription());
                messageJson.add("video", (JsonElement)video);
                break;
            }
            case "news": {
                JsonObject newsJsonObject = new JsonObject();
                JsonArray articleJsonArray = new JsonArray();
                for (NewArticle article : this.getArticles()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("title", article.getTitle());
                    articleJson.addProperty("description", article.getDescription());
                    articleJson.addProperty("url", article.getUrl());
                    articleJson.addProperty("picurl", article.getPicUrl());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("news", (JsonElement)newsJsonObject);
                break;
            }
            case "mpnews": {
                JsonObject newsJsonObject = new JsonObject();
                JsonArray articleJsonArray = new JsonArray();
                for (MpnewsArticle article : this.getMpNewsArticles()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("title", article.getTitle());
                    articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
                    articleJson.addProperty("author", article.getAuthor());
                    articleJson.addProperty("content_source_url", article.getContentSourceUrl());
                    articleJson.addProperty("content", article.getContent());
                    articleJson.addProperty("digest", article.getDigest());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("mpnews", (JsonElement)newsJsonObject);
                break;
            }
            case "miniprogram": {
                JsonObject miniprogram = new JsonObject();
                miniprogram.addProperty("appid", this.getAppId());
                miniprogram.addProperty("pagepath", this.getPagePath());
                miniprogram.addProperty("title", this.getTitle());
                miniprogram.addProperty("thumb_media_id", this.getThumbMediaId());
                messageJson.add("miniprogram", (JsonElement)miniprogram);
                break;
            }
        }
    }

    public static WxCpSchoolContactMessageBuilder builder() {
        return new WxCpSchoolContactMessageBuilder();
    }

    public Integer getRecvScope() {
        return this.recvScope;
    }

    public String[] getToParentUserId() {
        return this.toParentUserId;
    }

    public String[] getToStudentUserId() {
        return this.toStudentUserId;
    }

    public String[] getToParty() {
        return this.toParty;
    }

    public Boolean getToAll() {
        return this.toAll;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getContent() {
        return this.content;
    }

    public Boolean getEnableIdTrans() {
        return this.enableIdTrans;
    }

    public Boolean getEnableDuplicateCheck() {
        return this.enableDuplicateCheck;
    }

    public Integer getDuplicateCheckInterval() {
        return this.duplicateCheckInterval;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public List<NewArticle> getArticles() {
        return this.articles;
    }

    public List<MpnewsArticle> getMpNewsArticles() {
        return this.mpNewsArticles;
    }

    public WxCpSchoolContactMessage setRecvScope(Integer recvScope) {
        this.recvScope = recvScope;
        return this;
    }

    public WxCpSchoolContactMessage setToParentUserId(String[] toParentUserId) {
        this.toParentUserId = toParentUserId;
        return this;
    }

    public WxCpSchoolContactMessage setToStudentUserId(String[] toStudentUserId) {
        this.toStudentUserId = toStudentUserId;
        return this;
    }

    public WxCpSchoolContactMessage setToParty(String[] toParty) {
        this.toParty = toParty;
        return this;
    }

    public WxCpSchoolContactMessage setToAll(Boolean toAll) {
        this.toAll = toAll;
        return this;
    }

    public WxCpSchoolContactMessage setAgentId(Integer agentId) {
        this.agentId = agentId;
        return this;
    }

    public WxCpSchoolContactMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public WxCpSchoolContactMessage setEnableIdTrans(Boolean enableIdTrans) {
        this.enableIdTrans = enableIdTrans;
        return this;
    }

    public WxCpSchoolContactMessage setEnableDuplicateCheck(Boolean enableDuplicateCheck) {
        this.enableDuplicateCheck = enableDuplicateCheck;
        return this;
    }

    public WxCpSchoolContactMessage setDuplicateCheckInterval(Integer duplicateCheckInterval) {
        this.duplicateCheckInterval = duplicateCheckInterval;
        return this;
    }

    public WxCpSchoolContactMessage setMediaId(String mediaId) {
        this.mediaId = mediaId;
        return this;
    }

    public WxCpSchoolContactMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public WxCpSchoolContactMessage setDescription(String description) {
        this.description = description;
        return this;
    }

    public WxCpSchoolContactMessage setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
        return this;
    }

    public WxCpSchoolContactMessage setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public WxCpSchoolContactMessage setPagePath(String pagePath) {
        this.pagePath = pagePath;
        return this;
    }

    public WxCpSchoolContactMessage setArticles(List<NewArticle> articles) {
        this.articles = articles;
        return this;
    }

    public WxCpSchoolContactMessage setMpNewsArticles(List<MpnewsArticle> mpNewsArticles) {
        this.mpNewsArticles = mpNewsArticles;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpSchoolContactMessage)) {
            return false;
        }
        WxCpSchoolContactMessage other = (WxCpSchoolContactMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$recvScope = this.getRecvScope();
        Integer other$recvScope = other.getRecvScope();
        if (this$recvScope == null ? other$recvScope != null : !((Object)this$recvScope).equals(other$recvScope)) {
            return false;
        }
        Boolean this$toAll = this.getToAll();
        Boolean other$toAll = other.getToAll();
        if (this$toAll == null ? other$toAll != null : !((Object)this$toAll).equals(other$toAll)) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        Boolean this$enableIdTrans = this.getEnableIdTrans();
        Boolean other$enableIdTrans = other.getEnableIdTrans();
        if (this$enableIdTrans == null ? other$enableIdTrans != null : !((Object)this$enableIdTrans).equals(other$enableIdTrans)) {
            return false;
        }
        Boolean this$enableDuplicateCheck = this.getEnableDuplicateCheck();
        Boolean other$enableDuplicateCheck = other.getEnableDuplicateCheck();
        if (this$enableDuplicateCheck == null ? other$enableDuplicateCheck != null : !((Object)this$enableDuplicateCheck).equals(other$enableDuplicateCheck)) {
            return false;
        }
        Integer this$duplicateCheckInterval = this.getDuplicateCheckInterval();
        Integer other$duplicateCheckInterval = other.getDuplicateCheckInterval();
        if (this$duplicateCheckInterval == null ? other$duplicateCheckInterval != null : !((Object)this$duplicateCheckInterval).equals(other$duplicateCheckInterval)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getToParentUserId(), other.getToParentUserId())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getToStudentUserId(), other.getToStudentUserId())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getToParty(), other.getToParty())) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$thumbMediaId = this.getThumbMediaId();
        String other$thumbMediaId = other.getThumbMediaId();
        if (this$thumbMediaId == null ? other$thumbMediaId != null : !this$thumbMediaId.equals(other$thumbMediaId)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$pagePath = this.getPagePath();
        String other$pagePath = other.getPagePath();
        if (this$pagePath == null ? other$pagePath != null : !this$pagePath.equals(other$pagePath)) {
            return false;
        }
        List<NewArticle> this$articles = this.getArticles();
        List<NewArticle> other$articles = other.getArticles();
        if (this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles)) {
            return false;
        }
        List<MpnewsArticle> this$mpNewsArticles = this.getMpNewsArticles();
        List<MpnewsArticle> other$mpNewsArticles = other.getMpNewsArticles();
        return !(this$mpNewsArticles == null ? other$mpNewsArticles != null : !((Object)this$mpNewsArticles).equals(other$mpNewsArticles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpSchoolContactMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $recvScope = this.getRecvScope();
        result = result * 59 + ($recvScope == null ? 43 : ((Object)$recvScope).hashCode());
        Boolean $toAll = this.getToAll();
        result = result * 59 + ($toAll == null ? 43 : ((Object)$toAll).hashCode());
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        Boolean $enableIdTrans = this.getEnableIdTrans();
        result = result * 59 + ($enableIdTrans == null ? 43 : ((Object)$enableIdTrans).hashCode());
        Boolean $enableDuplicateCheck = this.getEnableDuplicateCheck();
        result = result * 59 + ($enableDuplicateCheck == null ? 43 : ((Object)$enableDuplicateCheck).hashCode());
        Integer $duplicateCheckInterval = this.getDuplicateCheckInterval();
        result = result * 59 + ($duplicateCheckInterval == null ? 43 : ((Object)$duplicateCheckInterval).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getToParentUserId());
        result = result * 59 + Arrays.deepHashCode(this.getToStudentUserId());
        result = result * 59 + Arrays.deepHashCode(this.getToParty());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $thumbMediaId = this.getThumbMediaId();
        result = result * 59 + ($thumbMediaId == null ? 43 : $thumbMediaId.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $pagePath = this.getPagePath();
        result = result * 59 + ($pagePath == null ? 43 : $pagePath.hashCode());
        List<NewArticle> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        List<MpnewsArticle> $mpNewsArticles = this.getMpNewsArticles();
        result = result * 59 + ($mpNewsArticles == null ? 43 : ((Object)$mpNewsArticles).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpSchoolContactMessage(recvScope=" + this.getRecvScope() + ", toParentUserId=" + Arrays.deepToString(this.getToParentUserId()) + ", toStudentUserId=" + Arrays.deepToString(this.getToStudentUserId()) + ", toParty=" + Arrays.deepToString(this.getToParty()) + ", toAll=" + this.getToAll() + ", msgType=" + this.getMsgType() + ", agentId=" + this.getAgentId() + ", content=" + this.getContent() + ", enableIdTrans=" + this.getEnableIdTrans() + ", enableDuplicateCheck=" + this.getEnableDuplicateCheck() + ", duplicateCheckInterval=" + this.getDuplicateCheckInterval() + ", mediaId=" + this.getMediaId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", thumbMediaId=" + this.getThumbMediaId() + ", appId=" + this.getAppId() + ", pagePath=" + this.getPagePath() + ", articles=" + this.getArticles() + ", mpNewsArticles=" + this.getMpNewsArticles() + ")";
    }

    public WxCpSchoolContactMessage() {
    }

    public WxCpSchoolContactMessage(Integer recvScope, String[] toParentUserId, String[] toStudentUserId, String[] toParty, Boolean toAll, String msgType, Integer agentId, String content, Boolean enableIdTrans, Boolean enableDuplicateCheck, Integer duplicateCheckInterval, String mediaId, String title, String description, String thumbMediaId, String appId, String pagePath, List<NewArticle> articles, List<MpnewsArticle> mpNewsArticles) {
        this.recvScope = recvScope;
        this.toParentUserId = toParentUserId;
        this.toStudentUserId = toStudentUserId;
        this.toParty = toParty;
        this.toAll = toAll;
        this.msgType = msgType;
        this.agentId = agentId;
        this.content = content;
        this.enableIdTrans = enableIdTrans;
        this.enableDuplicateCheck = enableDuplicateCheck;
        this.duplicateCheckInterval = duplicateCheckInterval;
        this.mediaId = mediaId;
        this.title = title;
        this.description = description;
        this.thumbMediaId = thumbMediaId;
        this.appId = appId;
        this.pagePath = pagePath;
        this.articles = articles;
        this.mpNewsArticles = mpNewsArticles;
    }

    public static class WxCpSchoolContactMessageBuilder {
        private Integer recvScope;
        private String[] toParentUserId;
        private String[] toStudentUserId;
        private String[] toParty;
        private Boolean toAll;
        private String msgType;
        private Integer agentId;
        private String content;
        private Boolean enableIdTrans;
        private Boolean enableDuplicateCheck;
        private Integer duplicateCheckInterval;
        private String mediaId;
        private String title;
        private String description;
        private String thumbMediaId;
        private String appId;
        private String pagePath;
        private List<NewArticle> articles;
        private List<MpnewsArticle> mpNewsArticles;

        WxCpSchoolContactMessageBuilder() {
        }

        public WxCpSchoolContactMessageBuilder recvScope(Integer recvScope) {
            this.recvScope = recvScope;
            return this;
        }

        public WxCpSchoolContactMessageBuilder toParentUserId(String[] toParentUserId) {
            this.toParentUserId = toParentUserId;
            return this;
        }

        public WxCpSchoolContactMessageBuilder toStudentUserId(String[] toStudentUserId) {
            this.toStudentUserId = toStudentUserId;
            return this;
        }

        public WxCpSchoolContactMessageBuilder toParty(String[] toParty) {
            this.toParty = toParty;
            return this;
        }

        public WxCpSchoolContactMessageBuilder toAll(Boolean toAll) {
            this.toAll = toAll;
            return this;
        }

        public WxCpSchoolContactMessageBuilder msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }

        public WxCpSchoolContactMessageBuilder agentId(Integer agentId) {
            this.agentId = agentId;
            return this;
        }

        public WxCpSchoolContactMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public WxCpSchoolContactMessageBuilder enableIdTrans(Boolean enableIdTrans) {
            this.enableIdTrans = enableIdTrans;
            return this;
        }

        public WxCpSchoolContactMessageBuilder enableDuplicateCheck(Boolean enableDuplicateCheck) {
            this.enableDuplicateCheck = enableDuplicateCheck;
            return this;
        }

        public WxCpSchoolContactMessageBuilder duplicateCheckInterval(Integer duplicateCheckInterval) {
            this.duplicateCheckInterval = duplicateCheckInterval;
            return this;
        }

        public WxCpSchoolContactMessageBuilder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public WxCpSchoolContactMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public WxCpSchoolContactMessageBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WxCpSchoolContactMessageBuilder thumbMediaId(String thumbMediaId) {
            this.thumbMediaId = thumbMediaId;
            return this;
        }

        public WxCpSchoolContactMessageBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public WxCpSchoolContactMessageBuilder pagePath(String pagePath) {
            this.pagePath = pagePath;
            return this;
        }

        public WxCpSchoolContactMessageBuilder articles(List<NewArticle> articles) {
            this.articles = articles;
            return this;
        }

        public WxCpSchoolContactMessageBuilder mpNewsArticles(List<MpnewsArticle> mpNewsArticles) {
            this.mpNewsArticles = mpNewsArticles;
            return this;
        }

        public WxCpSchoolContactMessage build() {
            return new WxCpSchoolContactMessage(this.recvScope, this.toParentUserId, this.toStudentUserId, this.toParty, this.toAll, this.msgType, this.agentId, this.content, this.enableIdTrans, this.enableDuplicateCheck, this.duplicateCheckInterval, this.mediaId, this.title, this.description, this.thumbMediaId, this.appId, this.pagePath, this.articles, this.mpNewsArticles);
        }

        public String toString() {
            return "WxCpSchoolContactMessage.WxCpSchoolContactMessageBuilder(recvScope=" + this.recvScope + ", toParentUserId=" + Arrays.deepToString(this.toParentUserId) + ", toStudentUserId=" + Arrays.deepToString(this.toStudentUserId) + ", toParty=" + Arrays.deepToString(this.toParty) + ", toAll=" + this.toAll + ", msgType=" + this.msgType + ", agentId=" + this.agentId + ", content=" + this.content + ", enableIdTrans=" + this.enableIdTrans + ", enableDuplicateCheck=" + this.enableDuplicateCheck + ", duplicateCheckInterval=" + this.duplicateCheckInterval + ", mediaId=" + this.mediaId + ", title=" + this.title + ", description=" + this.description + ", thumbMediaId=" + this.thumbMediaId + ", appId=" + this.appId + ", pagePath=" + this.pagePath + ", articles=" + this.articles + ", mpNewsArticles=" + this.mpNewsArticles + ")";
        }
    }
}

