/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaLiveService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaGetLiveInfo;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;

public class WxMaLiveServiceImpl
implements WxMaLiveService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private WxMaService service;

    @Override
    public WxMaGetLiveInfo getLiveInfo(Integer start, Integer limit) throws WxErrorException {
        JsonObject jsonObject = this.getJsonObject(start, limit, null);
        return WxMaGetLiveInfo.fromJson(jsonObject.toString());
    }

    @Override
    public List<WxMaGetLiveInfo.RoomInfo> getLiveinfos() throws WxErrorException {
        ArrayList<WxMaGetLiveInfo.RoomInfo> results = new ArrayList<WxMaGetLiveInfo.RoomInfo>();
        Integer start = 0;
        Integer limit = 80;
        Integer tatal = 0;
        WxMaGetLiveInfo liveInfo = null;
        while (tatal == 0 || tatal > start) {
            liveInfo = this.getLiveInfo(start, limit);
            if (liveInfo == null) {
                return null;
            }
            results.addAll(liveInfo.getRoomInfos());
            tatal = liveInfo.getTotal();
            start = results.size();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (results.size() <= tatal) continue;
        }
        return results;
    }

    @Override
    public WxMaGetLiveInfo getLiveReplay(String action, Integer room_id, Integer start, Integer limit) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("action", action);
        map.put("room_id", room_id);
        JsonObject jsonObject = this.getJsonObject(start, limit, map);
        return WxMaGetLiveInfo.fromJson(jsonObject.toString());
    }

    @Override
    public WxMaGetLiveInfo getLiveReplay(Integer room_id, Integer start, Integer limit) throws WxErrorException {
        return this.getLiveReplay("get_replay", room_id, start, limit);
    }

    private JsonObject getJsonObject(Integer start, Integer limit, Map<String, Object> map) throws WxErrorException {
        if (map == null) {
            map = new HashMap<String, Object>(2);
        }
        map.put("start", start);
        map.put("limit", limit);
        String responseContent = this.service.post("http://api.weixin.qq.com/wxa/business/getliveinfo", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject;
    }

    public WxMaLiveServiceImpl(WxMaService service) {
        this.service = service;
    }
}

