/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaSubscribeService;
import cn.binarywang.wx.miniapp.bean.template.WxMaPubTemplateTitleListResult;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.StringUtils;

public class WxMaSubscribeServiceImpl
implements WxMaSubscribeService {
    private WxMaService wxMaService;

    @Override
    public WxMaPubTemplateTitleListResult getPubTemplateTitleList(String[] ids, int start, int limit) throws WxErrorException {
        ImmutableMap params = ImmutableMap.of((Object)"ids", (Object)StringUtils.join((Object[])ids, (String)","), (Object)"start", (Object)start, (Object)"limit", (Object)limit);
        String responseText = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatetitles", Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)params));
        return WxMaPubTemplateTitleListResult.fromJson(responseText);
    }

    @Override
    public List<WxMaSubscribeService.PubTemplateKeyword> getPubTemplateKeyWordsById(String id) throws WxErrorException {
        String responseText = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatekeywords", Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)ImmutableMap.of((Object)"tid", (Object)id)));
        return (List)WxMaGsonBuilder.create().fromJson((JsonElement)new JsonParser().parse(responseText).getAsJsonObject().getAsJsonArray("data"), new TypeToken<List<WxMaSubscribeService.PubTemplateKeyword>>(){}.getType());
    }

    @Override
    public String addTemplate(String id, List<Integer> keywordIdList, String sceneDesc) throws WxErrorException {
        String responseText = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate", ImmutableMap.of((Object)"tid", (Object)id, (Object)"kidList", (Object)keywordIdList.toArray(), (Object)"sceneDesc", (Object)sceneDesc));
        return new JsonParser().parse(responseText).getAsJsonObject().get("priTmplId").getAsString();
    }

    @Override
    public List<WxMaSubscribeService.TemplateInfo> getTemplateList() throws WxErrorException {
        String responseText = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/newtmpl/gettemplate", null);
        return (List)WxMaGsonBuilder.create().fromJson((JsonElement)new JsonParser().parse(responseText).getAsJsonObject().getAsJsonArray("data"), new TypeToken<List<WxMaSubscribeService.TemplateInfo>>(){}.getType());
    }

    @Override
    public boolean delTemplate(String templateId) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/wxaapi/newtmpl/deltemplate", ImmutableMap.of((Object)"priTmplId", (Object)templateId));
        return true;
    }

    @Override
    public List<WxMaSubscribeService.CategoryData> getCategory() throws WxErrorException {
        String responseText = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/newtmpl/getcategory", null);
        return (List)WxMaGsonBuilder.create().fromJson((JsonElement)new JsonParser().parse(responseText).getAsJsonObject().getAsJsonArray("data"), new TypeToken<List<WxMaSubscribeService.CategoryData>>(){}.getType());
    }

    public WxMaSubscribeServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

