/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.equator;

import com.github.dadiyang.equator.Equator;
import com.github.dadiyang.equator.FieldInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractEquator
implements Equator {
    private static final List<Class<?>> WRAPPER = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class, String.class);
    private final List<String> includeFields;
    private final List<String> excludeFields;

    public AbstractEquator() {
        this.includeFields = Collections.emptyList();
        this.excludeFields = Collections.emptyList();
    }

    public AbstractEquator(List<String> includeFields, List<String> excludeFields) {
        this.includeFields = includeFields;
        this.excludeFields = excludeFields;
    }

    @Override
    public boolean isEquals(Object first, Object second) {
        List<FieldInfo> diff = this.getDiffFields(first, second);
        return diff == null || diff.isEmpty();
    }

    protected boolean isFieldEquals(FieldInfo fieldInfo) {
        if (this.isExclude(fieldInfo)) {
            return true;
        }
        if (!this.isInclude(fieldInfo)) {
            return true;
        }
        return this.nullableEquals(fieldInfo.getFirstVal(), fieldInfo.getSecondVal());
    }

    protected boolean isInclude(FieldInfo fieldInfo) {
        if (this.includeFields == null || this.includeFields.isEmpty()) {
            return true;
        }
        return this.includeFields.contains(fieldInfo.getFieldName());
    }

    protected boolean isExclude(FieldInfo fieldInfo) {
        return this.excludeFields != null && !this.excludeFields.isEmpty() && this.excludeFields.contains(fieldInfo.getFieldName());
    }

    List<FieldInfo> compareSimpleField(Object first, Object second) {
        boolean eq = Objects.equals(first, second);
        if (eq) {
            return Collections.emptyList();
        }
        Object obj = first == null ? second : first;
        Class<?> clazz = obj.getClass();
        return Collections.singletonList(new FieldInfo(clazz.getSimpleName(), clazz, first, second));
    }

    boolean isSimpleField(Object first, Object second) {
        Object obj = first == null ? second : first;
        Class<?> clazz = obj.getClass();
        return clazz.isPrimitive() || WRAPPER.contains(clazz);
    }

    private boolean nullableEquals(Object first, Object second) {
        if (first instanceof Collection && second instanceof Collection) {
            return Objects.deepEquals(((Collection)first).toArray(), ((Collection)second).toArray());
        }
        return Objects.deepEquals(first, second);
    }
}

