/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.paukov.combinatorics3.DuplicatedPermutationIterator;
import org.paukov.combinatorics3.IGenerator;
import org.paukov.combinatorics3.PermutationGenerator;
import org.paukov.combinatorics3.SimplePermutationIterator;

class SimplePermutationGenerator<T>
implements IGenerator<List<T>> {
    final boolean hasDuplicates;
    final boolean treatAsIdentical;
    final List<T> originalVector;

    SimplePermutationGenerator(Collection<T> vector, boolean treatAsIdentical) {
        this.hasDuplicates = PermutationGenerator.hasDuplicates(vector);
        this.treatAsIdentical = treatAsIdentical;
        this.originalVector = new ArrayList<T>(vector);
    }

    @Override
    public Iterator<List<T>> iterator() {
        if (this.isDuplicateIterator()) {
            return new DuplicatedPermutationIterator(this);
        }
        return new SimplePermutationIterator(this);
    }

    @Override
    public Stream<List<T>> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), false);
    }

    private boolean isDuplicateIterator() {
        return !this.treatAsIdentical && this.hasDuplicates;
    }
}

