/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec;

import com.github.f4b6a3.uuid.codec.StringCodec;
import com.github.f4b6a3.uuid.codec.UrnCodec;
import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import java.net.URI;
import java.util.UUID;

public class UriCodec
implements UuidCodec<URI> {
    public static final UriCodec INSTANCE = new UriCodec();

    @Override
    public URI encode(UUID uuid) {
        return URI.create(UrnCodec.INSTANCE.encode(uuid));
    }

    @Override
    public UUID decode(URI uri) {
        if (!UriCodec.isUuidUri(uri)) {
            throw InvalidUuidException.newInstance(uri);
        }
        return StringCodec.INSTANCE.decode(uri.toString());
    }

    public static boolean isUuidUri(URI uri) {
        return uri != null && UrnCodec.isUuidUrn(uri.toString());
    }
}

