/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.TimeFunction;
import com.github.f4b6a3.uuid.util.internal.RandomUtil;
import java.time.Clock;

public final class WindowsTimeFunction
implements TimeFunction {
    private final Clock clock;
    private long lastTime = -1L;
    private static final long GRANULARITY = 16L;
    private static final long TICKS_PER_GRANULARITY = 160000L;
    private long counter = Math.abs(RandomUtil.nextLong() % 160000L);
    private long counterMax = this.counter + 160000L;

    public WindowsTimeFunction() {
        this.clock = Clock.systemUTC();
    }

    public WindowsTimeFunction(Clock clock) {
        this.clock = clock;
    }

    @Override
    public long getAsLong() {
        ++this.counter;
        long time = this.calculatedMillis();
        if (time == this.lastTime) {
            if (this.counter >= this.counterMax) {
                while (time == this.lastTime) {
                    time = this.calculatedMillis();
                }
                this.counter %= 160000L;
                this.counterMax = this.counter + 160000L;
            }
        } else {
            this.counter %= 160000L;
            this.counterMax = this.counter + 160000L;
        }
        this.lastTime = time;
        return time * 10000L + this.counter;
    }

    private long calculatedMillis() {
        long time = this.clock.millis();
        return time + 16L - time % 16L;
    }
}

