/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.core.impl;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.opencc4j.core.ZhConvertCore;
import com.github.houbb.opencc4j.core.ZhConvertCoreContext;
import com.github.houbb.opencc4j.support.convert.context.impl.DefaultUnitConvertContext;
import com.github.houbb.opencc4j.support.convert.core.UnitConvert;
import com.github.houbb.opencc4j.support.datamap.IDataMap;
import com.github.houbb.opencc4j.support.segment.Segment;
import com.github.houbb.opencc4j.util.InnerCharUtils;
import java.util.List;
import java.util.Map;

public class ZhConvertCoreDefault
implements ZhConvertCore {
    @Override
    public String toSimple(String original, ZhConvertCoreContext context) {
        IDataMap dataMap = context.dataMap();
        return this.convert(original, context, dataMap.tsPhrase(), dataMap.tsChar());
    }

    @Override
    public String toTraditional(String original, ZhConvertCoreContext context) {
        IDataMap dataMap = context.dataMap();
        return this.convert(original, context, dataMap.stPhrase(), dataMap.stChar());
    }

    @Override
    public List<String> simpleList(String original, ZhConvertCoreContext context) {
        List simpleList = Guavas.newArrayList();
        List<String> segList = context.segment().seg(original);
        for (String seg : segList) {
            if (!this.isSimple(seg, context)) continue;
            simpleList.add(seg);
        }
        return simpleList;
    }

    @Override
    public List<String> traditionalList(String original, ZhConvertCoreContext context) {
        List traditionalList = Guavas.newArrayList();
        List<String> segList = context.segment().seg(original);
        for (String seg : segList) {
            if (!this.isTraditional(seg, context)) continue;
            traditionalList.add(seg);
        }
        return traditionalList;
    }

    @Override
    public boolean isSimple(char c, ZhConvertCoreContext context) {
        String sc = String.valueOf(c);
        return this.isSimple(sc, context);
    }

    @Override
    public boolean isSimple(String charOrPhrase, ZhConvertCoreContext context) {
        return context.isSimpleMatch().match(charOrPhrase, context);
    }

    @Override
    public boolean containsSimple(String charOrPhrase, ZhConvertCoreContext context) {
        if (StringUtil.isEmpty((String)charOrPhrase)) {
            return false;
        }
        List<String> chars = context.zhChars().chars(charOrPhrase);
        for (String c : chars) {
            if (!this.isSimple(c, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTraditional(char c, ZhConvertCoreContext context) {
        String sc = String.valueOf(c);
        return this.isTraditional(sc, context);
    }

    @Override
    public boolean isTraditional(String charOrPhrase, ZhConvertCoreContext context) {
        return context.isTraditionalMatch().match(charOrPhrase, context);
    }

    @Override
    public boolean containsTraditional(String charOrPhrase, ZhConvertCoreContext context) {
        if (StringUtil.isEmpty((String)charOrPhrase)) {
            return false;
        }
        List<String> chars = context.zhChars().chars(charOrPhrase);
        for (String c : chars) {
            if (!this.isTraditional(c, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChinese(char c, ZhConvertCoreContext context) {
        return CharUtil.isChinese((char)c);
    }

    @Override
    public boolean isChinese(String charOrPhrase, ZhConvertCoreContext context) {
        if (StringUtil.isEmpty((String)charOrPhrase)) {
            return false;
        }
        List<String> chars = context.zhChars().chars(charOrPhrase);
        for (String c : chars) {
            if (InnerCharUtils.isChineseForSingle(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsChinese(String charOrPhrase, ZhConvertCoreContext context) {
        if (StringUtil.isEmpty((String)charOrPhrase)) {
            return false;
        }
        List<String> chars = context.zhChars().chars(charOrPhrase);
        for (String c : chars) {
            if (!this.isChinese(c, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> toSimple(char c, ZhConvertCoreContext context) {
        IDataMap dataMap = context.dataMap();
        return dataMap.tsChar().get(String.valueOf(c));
    }

    @Override
    public List<String> toTraditional(char c, ZhConvertCoreContext context) {
        IDataMap dataMap = context.dataMap();
        return dataMap.stChar().get(String.valueOf(c));
    }

    protected String convert(String original, ZhConvertCoreContext context, Map<String, List<String>> phraseData, Map<String, List<String>> charData) {
        if (StringUtil.isEmpty((String)original)) {
            return original;
        }
        Segment segment = context.segment();
        List<String> stringList = segment.seg(original);
        if (CollectionUtil.isEmpty(stringList)) {
            return original;
        }
        UnitConvert unitConvert = context.unitConvert();
        DefaultUnitConvertContext unitConvertContext = new DefaultUnitConvertContext();
        unitConvertContext.setPhraseData(phraseData);
        unitConvertContext.setCharData(charData);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringList) {
            unitConvertContext.setUnit(string);
            String result = unitConvert.convert(unitConvertContext);
            stringBuilder.append(result);
        }
        return stringBuilder.toString();
    }
}

