/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.mockdata;

import com.github.jsonzou.jmockdata.mockdata.JmockDataInterceptor;
import com.github.jsonzou.jmockdata.mockdata.JmockDataTemplate;
import com.github.jsonzou.jmockdata.mockdata.JmockDataTemplateDefault;
import com.github.jsonzou.jmockdata.mockdata.JmockdataConfig;
import com.github.jsonzou.jmockdata.mockdata.MockData;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataBean;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataBigDecimal;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataBigDecimalArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataBigInteger;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataBigIntegerArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataBoolean;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataBooleanBoxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataBooleanUnboxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataByte;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataByteBoxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataByteUnboxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataCharacter;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataCharacterBoxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataCharacterUnboxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataDate;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataDateArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataDefaultNull;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataDouble;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataDoubleBoxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataDoubleUnboxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataFloat;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataFloatBoxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataFloatUnboxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataInteger;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataIntegerBoxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataIntegerUnboxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataLong;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataLongBoxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataLongUnboxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataProxy;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataShort;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataShortBoxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataShortUnboxingArray;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataString;
import com.github.jsonzou.jmockdata.mockdata.mocks.MockDataStringArray;
import com.github.jsonzou.jmockdata.utils.ReflectionUtil;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JMockDataManager {
    private static final String $_DEFAULT = "$_DEFAULT";
    private Map<String, MockData> mockDataMappings = new ConcurrentHashMap<String, MockData>();
    private List<JmockDataInterceptor> interceptors = new ArrayList<JmockDataInterceptor>();
    private JmockDataTemplate mockTemplate = new JmockDataTemplateDefault();
    private JmockdataConfig config = new JmockdataConfig();
    private Integer maxSelfRefLevel = 3;

    private JMockDataManager() {
        this.registerMockData(new MockDataByte(), Byte.TYPE, Byte.class);
        this.registerMockData(new MockDataByteUnboxingArray(), byte[].class);
        this.registerMockData(new MockDataByteBoxingArray(), Byte[].class);
        this.registerMockData(new MockDataShort(), Short.TYPE, Short.class);
        this.registerMockData(new MockDataShortUnboxingArray(), short[].class);
        this.registerMockData(new MockDataShortBoxingArray(), Short[].class);
        this.registerMockData(new MockDataInteger(), Integer.TYPE, Integer.class);
        this.registerMockData(new MockDataIntegerUnboxingArray(), int[].class);
        this.registerMockData(new MockDataIntegerBoxingArray(), Integer[].class);
        this.registerMockData(new MockDataLong(), Long.TYPE, Long.class);
        this.registerMockData(new MockDataLongUnboxingArray(), long[].class);
        this.registerMockData(new MockDataLongBoxingArray(), Long[].class);
        this.registerMockData(new MockDataFloat(), Float.TYPE, Float.class);
        this.registerMockData(new MockDataFloatUnboxingArray(), float[].class);
        this.registerMockData(new MockDataFloatBoxingArray(), Float[].class);
        this.registerMockData(new MockDataDouble(), Double.TYPE, Double.class);
        this.registerMockData(new MockDataDoubleUnboxingArray(), double[].class);
        this.registerMockData(new MockDataDoubleBoxingArray(), Double[].class);
        this.registerMockData(new MockDataBoolean(), Boolean.TYPE, Boolean.class);
        this.registerMockData(new MockDataBooleanUnboxingArray(), boolean[].class);
        this.registerMockData(new MockDataBooleanBoxingArray(), Boolean[].class);
        this.registerMockData(new MockDataCharacter(), Character.TYPE, Character.class);
        this.registerMockData(new MockDataCharacterUnboxingArray(), char[].class);
        this.registerMockData(new MockDataCharacterBoxingArray(), Character[].class);
        this.registerMockData(new MockDataString(), String.class);
        this.registerMockData(new MockDataStringArray(), String[].class);
        this.registerMockData(new MockDataBigDecimal(), BigDecimal.class);
        this.registerMockData(new MockDataBigDecimalArray(), BigDecimal[].class);
        this.registerMockData(new MockDataBigInteger(), BigInteger.class);
        this.registerMockData(new MockDataBigIntegerArray(), BigInteger[].class);
        this.registerMockData(new MockDataDate(), Date.class);
        this.registerMockData(new MockDataDateArray(), Date[].class);
        this.mockDataMappings.put($_DEFAULT, new MockDataDefaultNull());
    }

    public static JMockDataManager getInstance() {
        return JMockDataFactoryHolder.manager;
    }

    public void config(String configUnderClasspath) {
        JMockDataFactoryHolder.manager.getConfig().readConfig(configUnderClasspath);
    }

    public JmockdataConfig config() {
        return JMockDataFactoryHolder.manager.getConfig();
    }

    public <T> MockData<T> getMockDataBean(Class<T> clazz) {
        MockData mockData = this.mockDataMappings.get(ReflectionUtil.getClassName(clazz));
        if (mockData == null) {
            return new MockDataBean<T>(clazz);
        }
        return mockData;
    }

    public <T> MockData<T> getMockDataBean(Class<T> clazz, Type genericType) {
        MockData mockData = this.mockDataMappings.get(ReflectionUtil.getClassName(clazz));
        if (mockData == null) {
            return new MockDataBean<T>(clazz, genericType);
        }
        return mockData;
    }

    public <T> MockData<T> getDefaultMockDataBean(Class<T> clazz) {
        return new MockDataDefaultNull();
    }

    public Boolean isHas(Class clazz) {
        return this.mockDataMappings.containsKey(clazz.getName());
    }

    public void registerMockData(MockData mockData, Class ... registerClazz) {
        if (registerClazz != null && registerClazz.length > 0) {
            for (Class cla : registerClazz) {
                this.mockDataMappings.put(ReflectionUtil.getClassName(cla), this.proxy(mockData));
            }
        }
    }

    public List<JmockDataInterceptor> interceptors() {
        return this.interceptors;
    }

    public <T extends JmockDataInterceptor> void interceptors(Class<T> ... interceptors) {
        if (interceptors != null && interceptors.length > 0) {
            for (Class<T> inter : interceptors) {
                try {
                    this.interceptors().add((JmockDataInterceptor)ReflectionUtil.newInstance(inter));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public JmockDataTemplate getMockTemplate() {
        return this.mockTemplate;
    }

    public void setMockTemplate(JmockDataTemplate mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public List<JmockDataInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<JmockDataInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Map<String, MockData> getMockDataMappings() {
        return this.mockDataMappings;
    }

    public void setMockDataMappings(Map<String, MockData> mockDataMappings) {
        this.mockDataMappings = mockDataMappings;
    }

    public Integer getMaxSelfRefLevel() {
        return this.maxSelfRefLevel;
    }

    public void setMaxSelfRefLevel(Integer maxSelfRefLevel) {
        this.maxSelfRefLevel = maxSelfRefLevel;
    }

    private MockData proxy(MockData mockData) {
        return new MockDataProxy(mockData);
    }

    public JmockdataConfig getConfig() {
        return this.config;
    }

    public void setConfig(JmockdataConfig config) {
        this.config = config;
    }

    private static class JMockDataFactoryHolder {
        public static JMockDataManager manager = new JMockDataManager();

        private JMockDataFactoryHolder() {
        }
    }
}

