/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.mockdata;

import com.github.jsonzou.jmockdata.mockdata.JMockDataManager;
import com.github.jsonzou.jmockdata.mockdata.JmockDataContext;
import com.github.jsonzou.jmockdata.mockdata.JmockDataTemplate;
import com.github.jsonzou.jmockdata.mockdata.JmockdataConfig;
import com.github.jsonzou.jmockdata.utils.MockUtil;
import com.github.jsonzou.jmockdata.utils.RandomUtil;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class JmockDataTemplateDefault
implements JmockDataTemplate {
    private final Random random = new Random();

    @Override
    public JmockdataConfig getConfig() {
        return JMockDataManager.getInstance().getConfig();
    }

    @Override
    public BigDecimal mockBigDecimal(JmockDataContext context) {
        return new BigDecimal(this.mockDouble(context)).setScale((int)JMockDataManager.getInstance().config().getDecimalScale(), 1);
    }

    @Override
    public BigDecimal[] mockBigDecimalArray(JmockDataContext context) {
        BigDecimal[] mockDataArr = MockUtil.mockArray(BigDecimal.class, this.getConfig().getArrsizeBigdecimal()[0], this.getConfig().getArrsizeBigdecimal()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockBigDecimal(context));
        }
        return mockDataArr;
    }

    @Override
    public BigInteger mockBigInteger(JmockDataContext context) {
        return BigInteger.valueOf(this.mockLong(context));
    }

    @Override
    public BigInteger[] mockBigIntegerArray(JmockDataContext context) {
        BigInteger[] mockDataArr = MockUtil.mockArray(BigInteger.class, this.getConfig().getArrsizeBiginteger()[0], this.getConfig().getArrsizeBiginteger()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockBigInteger(context));
        }
        return mockDataArr;
    }

    @Override
    public Boolean mockBoolean(JmockDataContext context) {
        if (this.getConfig().getRangeBoolean()[0].equals(this.getConfig().getRangeBoolean()[1])) {
            return this.getConfig().getRangeBoolean()[0];
        }
        return this.random.nextBoolean();
    }

    @Override
    public boolean[] mockBooleanUnboxingArray(JmockDataContext context) {
        Boolean[] arrayData = this.mockBooleanBoxingArray(context);
        int len = arrayData.length;
        boolean[] mockData = new boolean[len];
        while (--len >= 0) {
            mockData[len] = arrayData[len];
        }
        return mockData;
    }

    @Override
    public Boolean[] mockBooleanBoxingArray(JmockDataContext context) {
        Boolean[] mockDataArr = MockUtil.mockArray(Boolean.class, this.getConfig().getArrsizeBoolean()[0], this.getConfig().getArrsizeBoolean()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockBoolean(context));
        }
        return mockDataArr;
    }

    @Override
    public Byte mockByte(JmockDataContext context) {
        byte[] nbyte = new byte[1];
        this.random.nextBytes(nbyte);
        return nbyte[0];
    }

    @Override
    public byte[] mockByteUnboxingArray(JmockDataContext context) {
        Byte[] arrayData = this.mockByteBoxingArray(context);
        int len = arrayData.length;
        byte[] mockData = new byte[len];
        while (--len >= 0) {
            mockData[len] = arrayData[len];
        }
        return mockData;
    }

    @Override
    public Byte[] mockByteBoxingArray(JmockDataContext context) {
        Byte[] mockDataArr = MockUtil.mockArray(Byte.class, this.getConfig().getArrsizeByte()[0], this.getConfig().getArrsizeByte()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockByte(context));
        }
        return mockDataArr;
    }

    @Override
    public Character mockCharacter(JmockDataContext context) {
        return JMockDataManager.getInstance().getConfig().getSeedCharacter()[RandomUtil.randomInteger(JMockDataManager.getInstance().getConfig().getSeedCharacter().length)];
    }

    @Override
    public char[] mockCharacterUnboxingArray(JmockDataContext context) {
        Character[] arrayData = this.mockCharacterBoxingArray(context);
        int len = arrayData.length;
        char[] mockData = new char[len];
        while (--len >= 0) {
            mockData[len] = arrayData[len].charValue();
        }
        return mockData;
    }

    @Override
    public Character[] mockCharacterBoxingArray(JmockDataContext context) {
        Character[] mockDataArr = MockUtil.mockArray(Character.class, this.getConfig().getArrsizeCharacter()[0], this.getConfig().getArrsizeCharacter()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockCharacter(context));
        }
        return mockDataArr;
    }

    @Override
    public Date mockDate(JmockDataContext context) {
        Calendar cld = Calendar.getInstance();
        cld.set(RandomUtil.randomInteger(this.getConfig().getRangeDateY()[0], this.getConfig().getRangeDateY()[1]), RandomUtil.randomInteger(this.getConfig().getRangeDateM()[0], this.getConfig().getRangeDateM()[1]), RandomUtil.randomInteger(this.getConfig().getRangeDateD()[0], this.getConfig().getRangeDateD()[1]), RandomUtil.randomInteger(this.getConfig().getRangeDateH()[0], this.getConfig().getRangeDateH()[1]), RandomUtil.randomInteger(this.getConfig().getRangeDateMi()[0], this.getConfig().getRangeDateMi()[1]), RandomUtil.randomInteger(this.getConfig().getRangeDateS()[0], this.getConfig().getRangeDateS()[1]));
        return cld.getTime();
    }

    @Override
    public Date[] mockDateArray(JmockDataContext context) {
        Date[] mockDataArr = MockUtil.mockArray(Date.class, this.getConfig().getArrsizeDate()[0], this.getConfig().getArrsizeDate()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockDate(context));
        }
        return mockDataArr;
    }

    @Override
    public Double mockDouble(JmockDataContext context) {
        return RandomUtil.randomDouble(JMockDataManager.getInstance().getConfig().getRangeDouble()[0], JMockDataManager.getInstance().getConfig().getRangeDouble()[1]);
    }

    @Override
    public double[] mockDoubleUnboxingArray(JmockDataContext context) {
        Double[] arrayData = this.mockDoubleBoxingArray(context);
        int len = arrayData.length;
        double[] mockData = new double[len];
        while (--len >= 0) {
            mockData[len] = arrayData[len];
        }
        return mockData;
    }

    @Override
    public Double[] mockDoubleBoxingArray(JmockDataContext context) {
        Double[] mockDataArr = MockUtil.mockArray(Double.class, this.getConfig().getArrsizeDouble()[0], this.getConfig().getArrsizeDouble()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockDouble(context));
        }
        return mockDataArr;
    }

    @Override
    public Float mockFloat(JmockDataContext context) {
        return RandomUtil.randomFloat(JMockDataManager.getInstance().getConfig().getRangeFloat()[0].floatValue(), JMockDataManager.getInstance().getConfig().getRangeFloat()[1].floatValue());
    }

    @Override
    public float[] mockFloatUnboxingArray(JmockDataContext context) {
        Float[] arrayData = this.mockFloatBoxingArray(context);
        int len = arrayData.length;
        float[] mockData = new float[len];
        while (--len >= 0) {
            mockData[len] = arrayData[len].floatValue();
        }
        return mockData;
    }

    @Override
    public Float[] mockFloatBoxingArray(JmockDataContext context) {
        Float[] mockDataArr = MockUtil.mockArray(Float.class, this.getConfig().getArrsizeFloat()[0], this.getConfig().getArrsizeFloat()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockFloat(context));
        }
        return mockDataArr;
    }

    @Override
    public Integer mockInteger(JmockDataContext context) {
        return RandomUtil.randomInteger(JMockDataManager.getInstance().getConfig().getRangeInteger()[0], JMockDataManager.getInstance().getConfig().getRangeInteger()[1]);
    }

    @Override
    public int[] mockIntegerUnboxingArray(JmockDataContext context) {
        Integer[] arrayData = this.mockIntegerBoxingArray(context);
        int len = arrayData.length;
        int[] mockData = new int[len];
        while (--len >= 0) {
            mockData[len] = arrayData[len];
        }
        return mockData;
    }

    @Override
    public Integer[] mockIntegerBoxingArray(JmockDataContext context) {
        Integer[] mockDataArr = MockUtil.mockArray(Integer.class, this.getConfig().getArrsizeInteger()[0], this.getConfig().getArrsizeInteger()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockInteger(context));
        }
        return mockDataArr;
    }

    @Override
    public Long mockLong(JmockDataContext context) {
        return RandomUtil.randomLong(JMockDataManager.getInstance().getConfig().getRangeLong()[0], JMockDataManager.getInstance().getConfig().getRangeLong()[1]);
    }

    @Override
    public long[] mockLongUnboxingArray(JmockDataContext context) {
        Long[] arrayData = this.mockLongBoxingArray(context);
        int len = arrayData.length;
        long[] mockData = new long[len];
        while (--len >= 0) {
            mockData[len] = arrayData[len];
        }
        return mockData;
    }

    @Override
    public Long[] mockLongBoxingArray(JmockDataContext context) {
        Long[] mockDataArr = MockUtil.mockArray(Long.class, this.getConfig().getArrsizeLong()[0], this.getConfig().getArrsizeLong()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockLong(context));
        }
        return mockDataArr;
    }

    @Override
    public Short mockShort(JmockDataContext context) {
        return RandomUtil.randomShort(JMockDataManager.getInstance().getConfig().getRangeShort()[0], JMockDataManager.getInstance().getConfig().getRangeShort()[1]);
    }

    @Override
    public short[] mockShortUnboxingArray(JmockDataContext context) {
        Short[] arrayData = this.mockShortBoxingArray(context);
        int len = arrayData.length;
        short[] mockData = new short[len];
        while (--len >= 0) {
            mockData[len] = arrayData[len];
        }
        return mockData;
    }

    @Override
    public Short[] mockShortBoxingArray(JmockDataContext context) {
        Short[] mockDataArr = MockUtil.mockArray(Short.class, this.getConfig().getArrsizeShort()[0], this.getConfig().getArrsizeShort()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockShort(context));
        }
        return mockDataArr;
    }

    @Override
    public String mockString(JmockDataContext context) {
        StringBuffer sb = new StringBuffer();
        int len = RandomUtil.randomInteger(10);
        for (int i = 0; i < len; ++i) {
            sb.append(JMockDataManager.getInstance().getConfig().getSeedString()[RandomUtil.randomInteger(JMockDataManager.getInstance().getConfig().getSeedString().length)]).append(" ");
        }
        return sb.toString();
    }

    @Override
    public String[] mockStringArray(JmockDataContext context) {
        String[] mockDataArr = MockUtil.mockArray(String.class, this.getConfig().getArrsizeString()[0], this.getConfig().getArrsizeString()[1]);
        int len = mockDataArr.length;
        while (--len >= 0) {
            Array.set(mockDataArr, len, this.mockString(context));
        }
        return mockDataArr;
    }
}

